/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.provider.sso2.support.convert.BasePlainSsoAuthenticationConvert;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.LdapSsoConvertProperty;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public class LdapSsoAuthenticationConvert
extends BasePlainSsoAuthenticationConvert {
    @Override
    public SsoTypeEnum supportType() {
        return SsoTypeEnum.LDAP;
    }

    @Override
    public <T extends SsoConvertProperty> Class<T> propertyType() {
        return LdapSsoConvertProperty.class;
    }

    @Override
    @Nullable
    public <T extends SsoConvertProperty> InternalAuthenticationGranter.InternalAuthenticationToken convert(HttpServletRequest request, HttpServletResponse response, T properties) {
        LdapSsoConvertProperty props = (LdapSsoConvertProperty)properties;
        String value = this.getParam(request, props.getParamName(), props.getParamIn());
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a:" + props.getParamName());
        }
        Object[] credentials = this.decodeBasicAuth(value);
        if (ArrayUtil.isEmpty((Object[])credentials) || CharSequenceUtil.isBlank((CharSequence)credentials[0])) {
            throw new IllegalArgumentException("\u6388\u6743\u8d26\u6237\u4e3a\u7a7a");
        }
        boolean authenticated = this.authenticateByLdap((String)credentials[0], (String)credentials[1], props);
        if (!authenticated) {
            throw new AuthorizationException("\u8ba4\u8bc1\u5931\u8d25, \u8bf7\u786e\u8ba4\u8d26\u6237\u5bc6\u7801\u4e00\u81f4");
        }
        return new InternalAuthenticationGranter.InternalAuthenticationToken(props.getIdType(), (String)credentials[0]);
    }

    private String[] decodeBasicAuth(String basicAuth) {
        String[] stringArray;
        String credentialsString;
        String[] credentials;
        if (basicAuth.startsWith("Basic ") || basicAuth.startsWith("basic ")) {
            basicAuth = basicAuth.substring(6);
        }
        if ((credentials = (credentialsString = new String(Base64.getDecoder().decode(basicAuth.getBytes(StandardCharsets.UTF_8)))).split(":")).length == 1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = URLDecoder.decode(credentials[0], StandardCharsets.UTF_8);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = URLDecoder.decode(credentials[0], StandardCharsets.UTF_8);
            stringArray = stringArray3;
            stringArray3[1] = URLDecoder.decode(credentials[1], StandardCharsets.UTF_8);
        }
        return stringArray;
    }

    private boolean authenticateByLdap(String principal, String password, LdapSsoConvertProperty props) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(8);
        if (CollUtil.isNotEmpty(props.getLoginAttributes())) {
            attributes.putAll(props.getLoginAttributes());
        }
        AndFilter filter = new AndFilter().and((Filter)new EqualsFilter(props.getLoginAttributeName(), principal));
        for (Map.Entry entry : attributes.entrySet()) {
            filter.and((Filter)(entry.getValue() instanceof Integer ? new EqualsFilter((String)entry.getKey(), ((Integer)entry.getValue()).intValue()) : new EqualsFilter((String)entry.getKey(), entry.getValue().toString())));
        }
        try {
            LdapTemplate ldapTemplate = this.buildLdapTemplate(props);
            return ldapTemplate.authenticate(props.getBase(), filter.encode(), password);
        }
        catch (Exception e) {
            throw new AuthorizationException("LDAP\u8ba4\u8bc1\u5931\u8d25," + e.getMessage(), (Throwable)e);
        }
    }

    private LdapTemplate buildLdapTemplate(LdapSsoConvertProperty props) {
        LdapContextSource contextSource = this.buildLdapContextSource(props);
        LdapSsoConvertProperty.Template template = props.getTemplate();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)contextSource);
        propertyMapper.from((Object)template.isIgnorePartialResultException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnorePartialResultException(arg_0));
        propertyMapper.from((Object)template.isIgnoreNameNotFoundException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreNameNotFoundException(arg_0));
        propertyMapper.from((Object)template.isIgnoreSizeLimitExceededException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreSizeLimitExceededException(arg_0));
        return ldapTemplate;
    }

    private LdapContextSource buildLdapContextSource(LdapSsoConvertProperty props) {
        Assert.notEmpty((Object[])props.getUrls(), (String)"LDAP url\u672a\u914d\u7f6e", (Object[])new Object[0]);
        LdapContextSource source = new LdapContextSource();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from((Object)props.getUsername()).to(arg_0 -> ((LdapContextSource)source).setUserDn(arg_0));
        propertyMapper.from((Object)props.getPassword()).to(arg_0 -> ((LdapContextSource)source).setPassword(arg_0));
        propertyMapper.from((Object)props.getAnonymousReadOnly()).to(arg_0 -> ((LdapContextSource)source).setAnonymousReadOnly(arg_0));
        propertyMapper.from((Object)props.getBase()).to(arg_0 -> ((LdapContextSource)source).setBase(arg_0));
        propertyMapper.from((Object)props.getUrls()).to(arg_0 -> ((LdapContextSource)source).setUrls(arg_0));
        propertyMapper.from(props.getBaseEnvironment()).to(baseEnvironment -> source.setBaseEnvironmentProperties(Collections.unmodifiableMap(baseEnvironment)));
        return source;
    }
}

