/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.provider.sso2.support.convert.BasePlainSsoAuthenticationConvert;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.OidcSsoConvertProperty;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OidcSsoAuthenticationConvert
extends BasePlainSsoAuthenticationConvert {
    private final RestTemplateHelper restTemplateHelper = RestTemplateHelper.instance((RestTemplate)RestTemplateFactory.instance());

    @Override
    public SsoTypeEnum supportType() {
        return SsoTypeEnum.OIDC;
    }

    @Override
    public <T extends SsoConvertProperty> Class<T> propertyType() {
        return OidcSsoConvertProperty.class;
    }

    @Override
    @Nullable
    public <T extends SsoConvertProperty> InternalAuthenticationGranter.InternalAuthenticationToken convert(HttpServletRequest request, HttpServletResponse response, T properties) {
        OidcSsoConvertProperty props = (OidcSsoConvertProperty)properties;
        String value = this.getParam(request, props.getParamName(), props.getParamIn());
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a:" + props.getParamName());
        }
        String accessToken = this.queryAccessToken(request, value, props);
        if (CharSequenceUtil.isBlank((CharSequence)accessToken)) {
            throw new BusinessException("\u67e5\u8be2\u8ba4\u8bc1\u670d\u52a1\u5668\u7684\u6388\u6743token\u4e3a\u7a7a");
        }
        String username = this.queryUsername(accessToken, props);
        if (CharSequenceUtil.isBlank((CharSequence)username)) {
            throw new BusinessException("\u6388\u6743\u8d26\u6237\u4e3a\u7a7a");
        }
        return new InternalAuthenticationGranter.InternalAuthenticationToken(props.getIdType(), username);
    }

    private String queryUsername(String accessToken, OidcSsoConvertProperty props) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap(4);
        headers.add((Object)"Authorization", (Object)("Bearer " + accessToken));
        Map userInfo = (Map)this.restTemplateHelper.exchange(props.getUserInfoEndpoint(), HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<HashMap<String, Object>>(){}, new Object[0]);
        if (CollUtil.isEmpty((Map)userInfo)) {
            return null;
        }
        return this.getValueByPath(props.getUserInfoParamPath(), userInfo);
    }

    private String queryAccessToken(HttpServletRequest request, String code, OidcSsoConvertProperty props) {
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)props.getAuthClientId());
        postParam.add((Object)"client_secret", (Object)props.getAuthClientSecret());
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
        postParam.add((Object)"code", (Object)code);
        String redirectUri = this.getParam(request, props.getRedirectUriParam(), props.getParamIn());
        if (CharSequenceUtil.isBlank((CharSequence)redirectUri)) {
            redirectUri = props.getRedirectUri();
        }
        Assert.notBlank((CharSequence)redirectUri, (String)"redirectUri\u4e3a\u7a7a", (Object[])new Object[0]);
        Map resp = (Map)this.restTemplateHelper.exchange(props.getAccessTokenEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<HashMap<String, Object>>(){}, new Object[0]);
        if (CollUtil.isEmpty((Map)resp)) {
            return null;
        }
        return (String)resp.get("access_token");
    }
}

