/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.common.SsoTypeEnum;
import com.elitescloud.boot.auth.provider.sso2.support.convert.BasePlainSsoAuthenticationConvert;
import com.elitescloud.boot.auth.provider.sso2.support.convert.properties.TicketSsoConvertProperty;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class TicketSsoAuthenticationConvert
extends BasePlainSsoAuthenticationConvert {
    private final RestTemplateHelper restTemplateHelper = RestTemplateHelper.instance((RestTemplate)RestTemplateFactory.instance());

    @Override
    public SsoTypeEnum supportType() {
        return SsoTypeEnum.TICKET;
    }

    @Override
    public <T extends SsoConvertProperty> Class<T> propertyType() {
        return TicketSsoConvertProperty.class;
    }

    @Override
    @Nullable
    public <T extends SsoConvertProperty> InternalAuthenticationGranter.InternalAuthenticationToken convert(HttpServletRequest request, HttpServletResponse response, T properties) {
        TicketSsoConvertProperty props = (TicketSsoConvertProperty)properties;
        String value = this.getParam(request, props.getParamName(), props.getParamIn());
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a:" + props.getParamName());
        }
        String username = this.getUsername(value, props);
        if (CharSequenceUtil.isBlank((CharSequence)username)) {
            throw new BusinessException("\u6388\u6743\u8d26\u6237\u4e3a\u7a7a");
        }
        return new InternalAuthenticationGranter.InternalAuthenticationToken(props.getIdType(), username);
    }

    private String getUsername(String ticket, TicketSsoConvertProperty props) {
        Assert.notBlank((CharSequence)props.getTicketParamName(), (String)"ticket\u53c2\u6570\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        String url = props.getUserInfoEndpoint();
        HttpHeaders headers = new HttpHeaders();
        HashMap<String, Object> body = new HashMap<String, Object>();
        switch (props.getUserInfoParamIn()) {
            case QUERY: {
                url = this.expendUrl(url, ticket, props);
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                break;
            }
            case FORM: {
                this.expandBody(body, ticket, props);
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                break;
            }
            case BODY: {
                this.expandBody(body, ticket, props);
                headers.setContentType(MediaType.APPLICATION_JSON);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u4f4d\u7f6e:" + String.valueOf(props.getUserInfoParamIn()));
            }
        }
        String resp = (String)this.restTemplateHelper.exchange(url, props.getUserInfoMethod(), new HttpEntity(body, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
        if (CharSequenceUtil.isBlank((CharSequence)resp) || CharSequenceUtil.isBlank((CharSequence)props.getUserInfoParamPath())) {
            return resp;
        }
        Map jsonResp = (Map)JSONUtil.json2Obj((String)resp, (TypeReference)new TypeReference<Map<String, Object>>(){}, (boolean)true, () -> "\u89e3\u6790\u7528\u6237\u4fe1\u606f\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
        return this.getValueByPath(props.getUserInfoParamPath(), jsonResp);
    }

    private String expendUrl(String url, String ticket, TicketSsoConvertProperty props) {
        UriComponentsBuilder urlBuilder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam(props.getTicketParamName(), new Object[]{ticket});
        if (CollUtil.isNotEmpty(props.getUserInfoAttributeMap())) {
            props.getUserInfoAttributeMap().forEach((x$0, xva$1) -> urlBuilder.queryParam(x$0, new Object[]{xva$1}));
        }
        return urlBuilder.toUriString();
    }

    private void expandBody(Map<String, Object> body, String ticket, TicketSsoConvertProperty props) {
        body.put(props.getTicketParamName(), ticket);
        if (CollUtil.isNotEmpty(props.getUserInfoAttributeMap())) {
            body.putAll(props.getUserInfoAttributeMap());
        }
    }
}

