/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.cas.provider.ClientTransferHelper;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.config.CloudtOAuth2ClientProperties;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.provider.config.properties.Sso2Properties;
import com.elitescloud.boot.auth.provider.sso2.common.SsoUserInfoConvert;
import com.elitescloud.boot.auth.provider.sso2.common.TicketProvider;
import com.elitescloud.boot.auth.provider.sso2.support.SsoServerSupportProvider;
import com.elitescloud.boot.auth.provider.sso2.support.impl.BaseSsoSupportProvider;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.ClientSecretBasicAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.ClientSecretPostAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.StringUtils;

public class DefaultSsoServerSupportProvider
extends BaseSsoSupportProvider
implements SsoServerSupportProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSsoServerSupportProvider.class);
    protected final Sso2Properties sso2Properties;
    protected final TicketProvider ticketProvider;
    private final AuthorizationSdkProperties sdkProperties;
    private final List<SsoUserInfoConvert<?>> userInfoConverts;
    private final ClientTransferHelper clientTransferHelper;
    private final List<AuthenticationConverter> authenticationConverters = List.of(new ClientSecretBasicAuthenticationConverter(), new ClientSecretPostAuthenticationConverter());

    public DefaultSsoServerSupportProvider(Sso2Properties sso2Properties, TicketProvider ticketProvider, List<SsoUserInfoConvert<?>> userInfoConverts, AuthorizationSdkProperties sdkProperties) {
        super(ticketProvider);
        this.sso2Properties = sso2Properties;
        this.ticketProvider = ticketProvider;
        this.userInfoConverts = userInfoConverts;
        this.sdkProperties = sdkProperties;
        this.clientTransferHelper = ClientTransferHelper.getInstance((String)sdkProperties.getAuthServer());
    }

    @Override
    public ApiResult<String> generateTicket(HttpServletRequest request, HttpServletResponse response) {
        String ticket = this.ticketProvider.generateTicket(request, response);
        return ApiResult.ok((Object)ticket);
    }

    @Override
    public ApiResult<Object> getUserDetail(HttpServletRequest request, HttpServletResponse response) {
        ClientInfo client = this.obtainClient(request);
        boolean validated = this.validateClient(request, client);
        String clientId = client == null ? null : client.getClientId();
        log.info("sso ticket2user\uff1a{}\uff0c{}", (Object)clientId, (Object)validated);
        if (!validated) {
            response.setStatus(401);
            return ApiResult.fail((ApiCode)ApiCode.UNAUTHORIZED, (String)"\u5ba2\u6237\u7aef\u9a8c\u8bc1\u5931\u8d25");
        }
        String ticket = this.obtainTicket(request);
        if (CharSequenceUtil.isBlank((CharSequence)ticket)) {
            return ApiResult.fail((String)"\u7968\u636eticket\u4e3a\u7a7a");
        }
        log.info("sso ticket\uff1a{}", (Object)ticket);
        GeneralUserDetails userDetails = this.retrieveUserDetails(request, ticket);
        if (userDetails == null) {
            return ApiResult.fail((String)"\u7968\u636eticket\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        Object userInfo = this.convertSsoUserInfo(userDetails.getUser(), clientId);
        log.info("sso convert user\uff1a{}, {}", (Object)clientId, userInfo);
        return ApiResult.ok((Object)userInfo);
    }

    @Override
    public ApiResult<String> ticketToToken(String ticket) {
        return null;
    }

    protected Object convertSsoUserInfo(SysUserDTO userDTO, String clientId) {
        if (userDTO == null || CharSequenceUtil.isBlank((CharSequence)clientId)) {
            return userDTO;
        }
        for (SsoUserInfoConvert<?> userInfoConvert : this.userInfoConverts) {
            if (!clientId.equals(userInfoConvert.supportClientId())) continue;
            return userInfoConvert.convertUser(userDTO);
        }
        return userDTO;
    }

    protected boolean validateClient(HttpServletRequest request, ClientInfo client) {
        if (Boolean.FALSE.equals(this.sso2Properties.getServer().getValidateClient())) {
            return true;
        }
        if (client == null) {
            log.info("sso\u9a8c\u8bc1\u5ba2\u6237\u7aef\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u5ba2\u6237\u7aef\u4fe1\u606f");
            return false;
        }
        CloudtOAuth2ClientProperties prop = this.sdkProperties.getCasClient().getOauth2Client();
        if (prop == null || CharSequenceUtil.isBlank((CharSequence)prop.getClientId())) {
            log.warn("\u672a\u914d\u7f6eOAuth2\u5ba2\u6237\u7aef");
            return false;
        }
        if (prop.getClientId().equals(client.getClientId())) {
            if (CharSequenceUtil.isBlank((CharSequence)prop.getClientSecret())) {
                return CharSequenceUtil.isBlank((CharSequence)client.getClientSecret());
            }
            return prop.getClientSecret().equals(client.getClientSecret());
        }
        Result validatedResult = this.clientTransferHelper.validateClient(client.getClientId(), client.getClientSecret());
        if (Boolean.TRUE.equals(validatedResult.getSuccess()) && Boolean.TRUE.equals(validatedResult.getData())) {
            return true;
        }
        log.info("\u6821\u9a8c\u5ba2\u6237\u7aef\u4e0d\u901a\u8fc7\uff1a{}\uff0c{}\uff0c{}", new Object[]{client.getClientId(), client.getClientSecret(), validatedResult});
        return false;
    }

    protected GeneralUserDetails retrieveUserDetails(HttpServletRequest request, String ticket) {
        String token = (String)this.ticketProvider.exchangeTicket(ticket);
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            return null;
        }
        GeneralUserDetails user = SecurityContextUtil.convertToken((String)token);
        user.getUser().setPassword(null);
        return user;
    }

    protected String obtainTicket(HttpServletRequest request) {
        String ticket = request.getParameter("ticket");
        if (StringUtils.hasText((String)ticket)) {
            return ticket;
        }
        ticket = request.getHeader("X-Auth-ticket");
        return ticket;
    }

    protected ClientInfo obtainClient(HttpServletRequest request) {
        for (AuthenticationConverter authenticationConverter : this.authenticationConverters) {
            Authentication authenticationToken = null;
            try {
                authenticationToken = authenticationConverter.convert(request);
            }
            catch (Exception e) {
                log.warn("\u89e3\u6790\u5ba2\u6237\u7aef\u5f02\u5e38\uff1a", (Throwable)e);
                continue;
            }
            if (authenticationToken == null) continue;
            if (authenticationToken instanceof OAuth2ClientAuthenticationToken) {
                OAuth2ClientAuthenticationToken clientToken = (OAuth2ClientAuthenticationToken)authenticationToken;
                return new ClientInfo((String)clientToken.getPrincipal(), (String)clientToken.getCredentials());
            }
            log.warn("\u89e3\u6790\u8ba4\u8bc1\u5ba2\u6237\u7aef\u5f02\u5e38\uff1a{}", (Object)authenticationToken.getClass().getName());
        }
        return null;
    }

    protected static class ClientInfo {
        private final String clientId;
        private final String clientSecret;

        public ClientInfo(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }
    }
}

