/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.crypto.digest.MD5;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.provider.config.properties.Sso2Properties;
import com.elitescloud.boot.auth.provider.sso2.common.TicketProvider;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.auth.util.SecurityUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.wrapper.RedisWrapper;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTicketProvider
implements TicketProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTicketProvider.class);
    private final RedisUtils redisUtils;
    protected final Sso2Properties sso2Properties;
    private final MD5 md5 = MD5.create();
    private RedisWrapper redisWrapper;

    public DefaultTicketProvider(RedisUtils redisUtils, Sso2Properties sso2Properties) {
        this.redisUtils = redisUtils;
        this.sso2Properties = sso2Properties;
    }

    @Override
    public String generateTicket(HttpServletRequest request, HttpServletResponse response) {
        String token = SecurityContextUtil.currentToken();
        if (token == null) {
            SecurityUtil.throwUnauthorizedException();
            return null;
        }
        String ticket = this.produceTicket(request, response, token);
        this.storageTicket(ticket, token);
        return ticket;
    }

    @Override
    public Object exchangeTicket(String ticket) {
        return this.retrieveTokenByTicket(ticket);
    }

    protected String produceTicket(HttpServletRequest request, HttpServletResponse response, String token) {
        String ticket = this.md5.digestHex(token + "::" + DatetimeUtil.currentTimeLong());
        logger.info("produce sso ticket\uff1a{}", (Object)ticket);
        return ticket;
    }

    protected void storageTicket(String ticket, String token) {
        Duration ttl = this.sso2Properties.getServer().getTicketTtl();
        long ttlSeconds = ttl == null ? -1L : ttl.toSeconds();
        this.supplyRedis(redis -> {
            redis.set("cloudt:sso:" + ticket, (Object)token, ttlSeconds, TimeUnit.SECONDS);
            return null;
        });
    }

    protected String retrieveTokenByTicket(String ticket) {
        String cacheKey = "cloudt:sso:" + ticket;
        return this.supplyRedis(redis -> {
            String token = (String)redis.get(cacheKey);
            if (CharSequenceUtil.isBlank((CharSequence)token)) {
                return null;
            }
            if (Boolean.TRUE.equals(this.sso2Properties.getServer().getExpireTicketOnUsed())) {
                redis.del(new String[]{cacheKey});
            }
            return token;
        });
    }

    protected <T> T supplyRedis(Function<RedisUtils, T> callback) {
        return (T)this.getRedisWrapper().apply(() -> callback.apply(this.redisUtils), null);
    }

    private RedisWrapper getRedisWrapper() {
        if (this.redisWrapper == null) {
            this.redisWrapper = (RedisWrapper)SpringContextHolder.getBean(RedisWrapper.class);
        }
        return this.redisWrapper;
    }
}

