/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.provider.sso2.support.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.config.properties.Sso2Properties;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.SsoAuthenticationConvert;
import com.elitescloud.boot.auth.provider.sso2.common.SsoConvertProperty;
import com.elitescloud.boot.auth.provider.sso2.support.SsoUnifyClientSupportProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ClassUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;

public class SsoUnifyClientSupportProviderImpl
implements SsoUnifyClientSupportProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SsoUnifyClientSupportProviderImpl.class);
    private static final String PARAM_AUTH_TYPE = "ac";
    private final Sso2Properties sso2Properties;
    private final InternalAuthenticationGranter internalAuthenticationGranter;
    private final List<SsoAuthenticationConvert> authenticationConverts;

    public SsoUnifyClientSupportProviderImpl(Sso2Properties sso2Properties, InternalAuthenticationGranter internalAuthenticationGranter, List<SsoAuthenticationConvert> authenticationConverts) {
        this.sso2Properties = sso2Properties;
        this.internalAuthenticationGranter = internalAuthenticationGranter;
        this.authenticationConverts = authenticationConverts;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sso2Properties.getUnifyClient() == null) {
            return;
        }
        if (CollUtil.isNotEmpty(this.sso2Properties.getUnifyClient().getClients())) {
            HashSet<String> existsAuthCodes = new HashSet<String>();
            for (Sso2Properties.UnifyClientProperty client : this.sso2Properties.getUnifyClient().getClients()) {
                if (!client.isEnabled()) continue;
                Assert.notBlank((CharSequence)client.getAuthCode(), (String)"\u6388\u6743\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
                Assert.isFalse((boolean)existsAuthCodes.contains(client.getAuthCode()), (String)("\u6388\u6743\u7f16\u7801\u5b58\u5728\u91cd\u590d\uff1a" + client.getAuthCode()), (Object[])new Object[0]);
                existsAuthCodes.add(client.getAuthCode());
                Assert.notNull((Object)((Object)client.getSsoType()), (String)"\u5b58\u5728\u914d\u7f6e\u5355\u70b9\u767b\u5f55\u7c7b\u578bssoType\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        if (CollUtil.isNotEmpty(this.authenticationConverts)) {
            for (SsoAuthenticationConvert authenticationConvert : this.authenticationConverts) {
                if (authenticationConvert.supportType() == null) {
                    throw new IllegalStateException(ClassUtil.getTargetClass((Object)authenticationConvert).getName() + "\u7684supportType\u4e3a\u7a7a");
                }
                if (authenticationConvert.propertyType() == null) {
                    throw new IllegalStateException(ClassUtil.getTargetClass((Object)authenticationConvert).getName() + "\u7684propertyType\u4e3a\u7a7a");
                }
                if (SsoConvertProperty.class.isAssignableFrom(authenticationConvert.propertyType())) continue;
                throw new IllegalStateException(ClassUtil.getTargetClass((Object)authenticationConvert).getName() + "\u7684propertyType\u7c7b\u578b\u9519\u8bef");
            }
        }
    }

    @Override
    public ApiResult<OAuthToken> authenticate(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        Sso2Properties.UnifyClientProperty clientProperty = this.obtainProperty(request);
        if (clientProperty == null) {
            return ApiResult.fail((String)"\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u65b9\u5f0f");
        }
        SsoAuthenticationConvert authenticationConvert = this.matchConvert(request, clientProperty);
        if (authenticationConvert == null) {
            return ApiResult.fail((String)"\u4e0d\u652f\u6301\u7684\u8ba4\u8bc1\u7c7b\u578b");
        }
        SsoConvertProperty convertProperty = this.convertProperty(clientProperty, authenticationConvert.propertyType());
        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = authenticationConvert.convert(request, response, convertProperty);
        if (authenticationToken == null) {
            return ApiResult.fail((String)"\u8f6c\u6362\u8ba4\u8bc1\u4ee4\u724c\u5931\u8d25");
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)clientProperty.getClientId())) {
            request.setAttribute("cloudtClientId", (Object)clientProperty.getClientId());
        }
        OAuthToken token = null;
        try {
            token = this.internalAuthenticationGranter.authenticate(request, response, authenticationToken);
        }
        catch (AuthenticationException e) {
            return ApiResult.fail((String)("\u8ba4\u8bc1\u5f02\u5e38\uff0c" + e.getMessage()));
        }
        response.setStatus(HttpStatus.OK.value());
        return ApiResult.ok((Object)token);
    }

    private SsoConvertProperty convertProperty(Sso2Properties.UnifyClientProperty clientProperty, Class<?> clazz) {
        SsoConvertProperty convertProperty = null;
        try {
            convertProperty = CollUtil.isEmpty((Map)clientProperty.getProperties()) ? (SsoConvertProperty)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (SsoConvertProperty)JSONUtil.convertObj((Object)clientProperty.getProperties(), clazz, (boolean)true);
        }
        catch (Exception e) {
            throw new BusinessException("\u8ba4\u8bc1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Throwable)e);
        }
        convertProperty.setParamName(clientProperty.getParamName());
        convertProperty.setParamIn(clientProperty.getParamIn());
        convertProperty.setIdType(clientProperty.getIdType());
        convertProperty.setClientId(clientProperty.getClientId());
        convertProperty.validate();
        return convertProperty;
    }

    private Sso2Properties.UnifyClientProperty obtainProperty(HttpServletRequest request) {
        String authTypeCode = request.getParameter(PARAM_AUTH_TYPE);
        if (CharSequenceUtil.isBlank((CharSequence)authTypeCode)) {
            throw new BusinessException("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\uff1aac");
        }
        if (this.sso2Properties.getUnifyClient() == null || CollUtil.isEmpty(this.sso2Properties.getUnifyClient().getClients())) {
            return null;
        }
        for (Sso2Properties.UnifyClientProperty client : this.sso2Properties.getUnifyClient().getClients()) {
            if (!authTypeCode.equals(client.getAuthCode())) continue;
            return client;
        }
        return null;
    }

    private SsoAuthenticationConvert matchConvert(HttpServletRequest request, Sso2Properties.UnifyClientProperty property) {
        if (CollUtil.isEmpty(this.authenticationConverts) || property == null) {
            return null;
        }
        for (SsoAuthenticationConvert authenticationConvert : this.authenticationConverts) {
            if (authenticationConvert.supportType() == null || authenticationConvert.supportType() != property.getSsoType()) continue;
            return authenticationConvert;
        }
        return null;
    }
}

