package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.provider.OAuth2ClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 自动刷新客户端token.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/15
 */
public class AutoRefreshClientTokenTask implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshClientTokenTask.class);
    private final OAuth2ClientProvider oAuth2ClientProvider;

    public AutoRefreshClientTokenTask(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
    }

    @Override
    public void run() {
        var tokenResult = oAuth2ClientProvider.clientToken();
        if (Boolean.TRUE.equals(tokenResult.getSuccess())) {
            ClientTokenHolder.setToken(tokenResult.getData());
            LOG.info("客户端token刷新：{}", tokenResult.getData());
            return;
        }

        LOG.error("CAS客户端token获取失败：{}", tokenResult);
    }
}
