package com.elitescloud.boot.auth.config;

import java.io.Serializable;

/**
 * OAuth2客户端信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/11
 */
public class CloudtOAuth2Client implements Serializable {
    private static final long serialVersionUID = 6041327278295060654L;

    /**
     * 客户端ID
     */
    private String clientId;
    /**
     * 客户端secret
     */
    private String clientSecret;
    /**
     * 是否启用pkce
     */
    private boolean pkceEnabled = true;
    /**
     * 服务端认证地址
     */
    private String authorizeEndpoint;
    /**
     * 服务端生成token地址
     */
    private String tokenEndpoint;
    /**
     * 用户信息地址
     */
    private String userinfoEndpoint;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isPkceEnabled() {
        return pkceEnabled;
    }

    public void setPkceEnabled(boolean pkceEnabled) {
        this.pkceEnabled = pkceEnabled;
    }

    public String getAuthorizeEndpoint() {
        return authorizeEndpoint;
    }

    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }

    public String getTokenEndpoint() {
        return tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserinfoEndpoint() {
        return userinfoEndpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }
}
