package com.elitescloud.boot.auth.sso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * ticket处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
public interface TicketResolver {

    /**
     * 获取ticket
     *
     * @param request request
     * @return ticket
     */
    String obtain(HttpServletRequest request);

    /**
     * 保存ticket
     *
     * @param request  request
     * @param response response
     * @param ticket   ticket
     */
    void save(HttpServletRequest request, HttpServletResponse response, String ticket);

    /**
     * 清掉ticket
     *
     * @param request  request
     * @param response response
     */
    void clear(HttpServletRequest request, HttpServletResponse response);
}
