/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.task.ClientTokenHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.util.RestTemplateFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public abstract class BaseTransferHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTransferHelper.class);
    private final RestTemplate restTemplate = RestTemplateFactory.instance(builder -> builder.rootUri(authServer).additionalInterceptors(new ClientHttpRequestInterceptor[]{new AuthorizationInterceptor()}));

    BaseTransferHelper(String authServer) {
    }

    <T> T nullToDefault(T obj, T defaultObj) {
        return obj == null ? defaultObj : obj;
    }

    <T> T remoteExchange(String url, HttpMethod httpMethod, HttpEntity<?> httpEntity, ParameterizedTypeReference<T> responseType, Object ... param) {
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, httpMethod, httpEntity, responseType, param);
        }
        catch (RestClientException e) {
            LOG.error("\u8ba4\u8bc1\u6388\u6743\u670d\u52a1\u5668\u8c03\u7528\u5931\u8d25\uff1a", (Throwable)e);
            throw new RuntimeException("\u8ba4\u8bc1\u6388\u6743\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.error("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5668\u63a5\u53e3\u5931\u8d25\uff1a{}, {}", (Object)url, (Object)response);
            throw new RuntimeException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5668\u63a5\u53e3\u5931\u8d25");
        }
        LOG.info("\u63a5\u53e3{}\u8c03\u7528\u6210\u529f", (Object)url);
        return (T)response.getBody();
    }

    static class AuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        AuthorizationInterceptor() {
        }

        @NonNull
        public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
            HttpHeaders headers = request.getHeaders();
            OAuthToken token = ClientTokenHolder.getToken();
            if (token == null) {
                throw new IllegalStateException("Token\u83b7\u53d6\u5931\u8d25");
            }
            headers.add("Authorization", token.getTokenType() + " " + token.getAccessToken());
            return execution.execute(request, body);
        }
    }
}

