/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.provider.OAuth2ClientProvider;
import com.elitescloud.boot.auth.cas.task.ClientTokenHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.model.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRefreshClientTokenTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshClientTokenTask.class);
    private final OAuth2ClientProvider oAuth2ClientProvider;

    public AutoRefreshClientTokenTask(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
    }

    @Override
    public void run() {
        Result<OAuthToken> tokenResult = this.oAuth2ClientProvider.clientToken();
        if (Boolean.TRUE.equals(tokenResult.getSuccess())) {
            ClientTokenHolder.setToken(tokenResult.getData());
            LOG.info("\u5ba2\u6237\u7aeftoken\u5237\u65b0\uff1a{}", (Object)tokenResult.getData());
            return;
        }
        LOG.error("CAS\u5ba2\u6237\u7aeftoken\u83b7\u53d6\u5931\u8d25\uff1a{}", tokenResult);
    }
}

