/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.authorization.sdk.model.Result;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AutoSyncUserTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoSyncUserTask.class);
    private static final int MAX_SIZE = 100;
    private final UserSourceProvider userSyncProvider;
    private final UserTransferHelper transferHelper;
    private int syncSize = 50;
    private boolean rollbackAllOnException;

    public AutoSyncUserTask(String authServer, UserSourceProvider userSyncProvider) {
        this.userSyncProvider = userSyncProvider;
        this.transferHelper = UserTransferHelper.getInstance(authServer);
    }

    @Override
    public void run() {
        if (this.userSyncProvider == null) {
            return;
        }
        if (this.syncSize < 1) {
            return;
        }
        int size = Math.min(this.syncSize, 100);
        List<AuthUserDTO> users = this.userSyncProvider.queryUser(size);
        while (!CollectionUtils.isEmpty(users)) {
            Result<HashMap<String, Long>> result = this.transferHelper.upsertUserBatch(this.rollbackAllOnException, users);
            if (!result.getSuccess().booleanValue()) {
                LOG.error("CAS\u540c\u6b65\u7528\u6237\u8d26\u53f7\u5931\u8d25\uff1a{}", (Object)result.getMsg());
                break;
            }
            if (!CollectionUtils.isEmpty((Map)((Map)result.getData()))) {
                this.userSyncProvider.successCallback((Map)result.getData());
            }
            users = this.userSyncProvider.queryUser(size);
        }
    }

    public void setSyncSize(int syncSize) {
        Assert.isTrue((syncSize < 100 ? 1 : 0) != 0, (String)"\u6700\u5927\u503c\u4e3a100");
        this.syncSize = syncSize;
    }

    public void setRollbackAllOnException(boolean rollbackAllOnException) {
        this.rollbackAllOnException = rollbackAllOnException;
    }
}

