/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.config.CasClientProperties;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientProvider;
import com.elitescloud.boot.auth.cas.task.AutoRefreshClientTokenTask;
import com.elitescloud.boot.auth.cas.task.AutoSyncUserTask;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class CasClientScheduler
implements SchedulingConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(CasClientScheduler.class);
    private final AuthorizationSdkProperties sdkProperties;
    private UserSourceProvider userSourceProvider;
    private OAuth2ClientProvider oAuth2ClientProvider;

    public CasClientScheduler(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        this.addClientTokenRefreshTask(taskRegistrar);
        this.addSyncUserTask(taskRegistrar);
    }

    private void addSyncUserTask(ScheduledTaskRegistrar taskRegistrar) {
        long interval;
        if (this.userSourceProvider == null) {
            return;
        }
        CasClientProperties casClient = this.sdkProperties.getCasClient();
        long l = interval = casClient.getSyncInterval() == null ? 0L : casClient.getSyncInterval().toMillis();
        if (interval < 1L) {
            LOG.warn("CAS\u81ea\u52a8\u540c\u6b65\u7528\u6237\u5df2\u5173\u95ed");
            return;
        }
        AutoSyncUserTask task = new AutoSyncUserTask(this.sdkProperties.getAuthServer(), this.userSourceProvider);
        taskRegistrar.addFixedDelayTask(() -> {
            if (!Boolean.TRUE.equals(this.sdkProperties.getCasClient().getEnabled())) {
                return;
            }
            try {
                task.setSyncSize(casClient.getSyncSize());
                task.setRollbackAllOnException(Boolean.TRUE.equals(casClient.getRollBackAllOnException()));
                task.run();
            }
            catch (Exception e) {
                LOG.error("\u6267\u884c\u540c\u6b65\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }, interval);
    }

    private void addClientTokenRefreshTask(ScheduledTaskRegistrar taskRegistrar) {
        long interval;
        if (this.oAuth2ClientProvider == null) {
            return;
        }
        long l = interval = this.sdkProperties.getCasClient().getClientTokenInterval() == null ? 0L : this.sdkProperties.getCasClient().getClientTokenInterval().toMillis();
        if (interval < 1L) {
            LOG.warn("CAS\u81ea\u52a8\u540c\u6b65\u5237\u65b0\u5ba2\u6237\u7aeftoken\u5df2\u5173\u95ed");
            return;
        }
        AutoRefreshClientTokenTask task = new AutoRefreshClientTokenTask(this.oAuth2ClientProvider);
        taskRegistrar.addFixedDelayTask(() -> {
            if (!Boolean.TRUE.equals(this.sdkProperties.getCasClient().getEnabled())) {
                return;
            }
            try {
                task.run();
            }
            catch (Exception e) {
                LOG.error("\u6267\u884c\u5237\u65b0\u5ba2\u6237\u7aeftoken\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }, interval);
    }

    @Autowired(required=false)
    public void setUserSourceProvider(UserSourceProvider userSourceProvider) {
        this.userSourceProvider = userSourceProvider;
    }

    @Autowired(required=false)
    public void setoAuth2ClientProvider(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
    }
}

