/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.util;

import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.sso.model.UserInfoDTO;
import com.elitescloud.boot.auth.util.RestTemplateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

public class AuthorizationServerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationServerHelper.class);
    private final RestTemplate restTemplate = RestTemplateFactory.instance();

    private AuthorizationServerHelper() {
    }

    public static AuthorizationServerHelper getInstance() {
        return new AuthorizationServerHelper();
    }

    @Nullable
    public UserInfoDTO ticket2UserInfo(String authServer, String ticket) {
        String url = this.normalizeUrl(authServer) + "/oauth/sso/userInfo?ticket=" + ticket;
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Result<UserInfoDTO>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful() && resp.getBody() != null) {
                return (UserInfoDTO)((Result)resp.getBody()).getData();
            }
            LOG.error("ticket\u6362\u53d6\u7528\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}\uff0c{}", (Object)resp.getStatusCode(), resp.getBody());
            return null;
        }
        catch (Exception e) {
            LOG.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)url);
            LOG.error("ticket\u6362\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            throw new IllegalStateException("\u8bf7\u6c42\u8ba4\u8bc1\u670d\u52a1\u5668\u5931\u8d25", e);
        }
    }

    public String generateTicket(String authServer, String account, String accountType) {
        String url = this.normalizeUrl(authServer) + "/oauth/sso/ticket?account_type=" + accountType + "&account=" + account;
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Result<String>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful() && resp.getBody() != null) {
                return (String)((Result)resp.getBody()).getData();
            }
            LOG.info("ticket\u751f\u6210\u7ed3\u679c\uff1a{}\uff0c{}", (Object)resp.getStatusCode(), resp.getBody());
            return null;
        }
        catch (Exception e) {
            LOG.error("\u751f\u6210ticket\u8def\u5f84\uff1a{}", (Object)url);
            LOG.error("\u751f\u6210ticket\u5f02\u5e38\uff1a", (Throwable)e);
            throw new IllegalStateException("\u751f\u6210ticket\u5931\u8d25", e);
        }
    }

    public void revokeTicket(String authServer, String ticket) {
        String url = this.normalizeUrl(authServer) + "/oauth/sso/revoke?ticket=" + ticket;
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.DELETE, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Result<String>>(){}, new Object[0]);
            LOG.info("ticket\u6ce8\u9500\u7ed3\u679c\uff1a{}\uff0c{}", (Object)resp.getStatusCode(), resp.getBody());
        }
        catch (Exception e) {
            LOG.error("\u6ce8\u9500\u8def\u5f84\uff1a{}", (Object)url);
            LOG.error("ticket\u6ce8\u9500\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void clientLogout(String clientAddress, String uri, String ticket) {
        String url = this.normalizeUrl(clientAddress) + uri + "?ticket=" + ticket;
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.DELETE, null, (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
            LOG.info("client\u6ce8\u9500\u7ed3\u679c\uff1a{}\uff0c{}", (Object)resp.getStatusCode(), resp.getBody());
        }
        catch (Exception e) {
            LOG.error("client\u6ce8\u9500\u8def\u5f84\uff1a{}", (Object)url);
            LOG.error("client\u6ce8\u9500\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private String normalizeUrl(String url) {
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

