/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.util;

import com.elitescloud.boot.auth.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestTemplateFactory {
    private RestTemplateFactory() {
    }

    public static RestTemplate instance() {
        return RestTemplateFactory.instance(null);
    }

    public static RestTemplate instance(Function<RestTemplateBuilder, RestTemplateBuilder> restTemplateBuilderFunction) {
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(RestTemplateFactory::getClientHttpRequestFactory).customizers(new RestTemplateCustomizer[]{RestTemplateFactory.restTemplateCustomizer()});
        if (restTemplateBuilderFunction != null) {
            builder = restTemplateBuilderFunction.apply(builder);
        }
        return builder.build();
    }

    private static ClientHttpRequestFactory getClientHttpRequestFactory() {
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setSSLSocketFactory(sslConnectionSocketFactory);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClientBuilder.build());
        requestFactory.setConnectTimeout((int)Duration.ofSeconds(10L).toMillis());
        requestFactory.setReadTimeout((int)Duration.ofSeconds(60L).toMillis());
        return requestFactory;
    }

    private static RestTemplateCustomizer restTemplateCustomizer() {
        ObjectMapper objectMapper = ObjectMapperFactory.instance();
        return template -> {
            for (HttpMessageConverter convert : template.getMessageConverters()) {
                if (!(convert instanceof MappingJackson2HttpMessageConverter)) continue;
                ((MappingJackson2HttpMessageConverter)convert).setObjectMapper(objectMapper);
                return;
            }
            template.getMessageConverters().add(new MappingJackson2HttpMessageConverter(objectMapper));
        };
    }
}

