package com.elitescloud.boot.auth.cas;

import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;

import java.util.List;
import java.util.Map;

/**
 * 业务端用户来源.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/3
 */
public interface UserSourceProvider {

    /**
     * 分页查询用户去同步
     * <p>
     * 当返回结果为空时表示同步结束
     *
     * @param zie 同步数量
     * @return 用户列表
     */
    List<AuthUserDTO> queryUser(int zie);

    /**
     * 同步成功后的回调
     *
     * @param user 用户账号与CAS的用户ID映射
     */
    void successCallback(Map<String, Long> user);
}
