package com.elitescloud.boot.auth.cas.model;

import java.io.Serializable;
import java.time.Duration;

/**
 * 客户端用户信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/18
 */
public class AuthClientUserDTO implements Serializable {
    private static final long serialVersionUID = -6459708902169395824L;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 客户端token有效期
     */
    private Duration tokenTtl;

    /**
     * token是否支持刷新
     */
    private Boolean tokenRenewal;

    /**
     * 刷新token有效期
     */
    private Duration refreshTokenTtl;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户名称
     */
    private String username;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Duration getTokenTtl() {
        return tokenTtl;
    }

    public void setTokenTtl(Duration tokenTtl) {
        this.tokenTtl = tokenTtl;
    }

    public Boolean getTokenRenewal() {
        return tokenRenewal;
    }

    public void setTokenRenewal(Boolean tokenRenewal) {
        this.tokenRenewal = tokenRenewal;
    }

    public Duration getRefreshTokenTtl() {
        return refreshTokenTtl;
    }

    public void setRefreshTokenTtl(Duration refreshTokenTtl) {
        this.refreshTokenTtl = refreshTokenTtl;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}
