package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.provider.OAuth2ClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

/**
 * 自动刷新客户端token.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/15
 */
public class AutoRefreshClientTokenTask implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshClientTokenTask.class);
    private static final int MAX_RETRY_TIMES = 5;
    private final OAuth2ClientProvider oAuth2ClientProvider;

    public AutoRefreshClientTokenTask(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
        ClientTokenHolder.setTokenSupplier(() -> oAuth2ClientProvider.clientToken().getData());
    }

    @Override
    public void run() {
        var result = this.execute();
        if (result) {
            return;
        }

        // 失败后重试
        int retryTimes = 0;
        while (retryTimes < MAX_RETRY_TIMES) {
            try {
                TimeUnit.MINUTES.sleep(retryTimes + 1);
            } catch (InterruptedException ignored) {
            }

            LOG.info("第{}次尝试重新获取客户端token", retryTimes);
            result = this.execute();
            if (result) {
                // 获取成功
                break;
            }
            retryTimes++;
        }

    }

    private boolean execute() {
        var tokenResult = oAuth2ClientProvider.clientToken();
        if (Boolean.TRUE.equals(tokenResult.getSuccess())) {
            ClientTokenHolder.setToken(tokenResult.getData());
            LOG.info("客户端token刷新：{}", tokenResult.getData());
            return true;
        }

        LOG.error("CAS客户端token获取失败：{}", tokenResult);
        return false;
    }
}
