package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.model.OAuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Supplier;

/**
 * 客户端token.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/15
 */
public class ClientTokenHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTokenHolder.class);

    private static volatile OAuthToken token;
    private static Supplier<OAuthToken> tokenSupplier;

    private ClientTokenHolder() {
    }

    /**
     * 设置token
     *
     * @param token
     */
    public static void setToken(OAuthToken token) {
        ClientTokenHolder.token = token;
    }

    /**
     * 获取token
     *
     * @return
     */
    public static OAuthToken getToken() {
        if (token == null && tokenSupplier != null) {
            token = tokenSupplier.get();
        }
        return ClientTokenHolder.token;
    }

    /**
     * 刷新token
     */
    public static void refresh() {
        if (tokenSupplier != null) {
            token = tokenSupplier.get();
            LOG.info("client token刷新成功");
            return;
        }
        LOG.info("client token刷新失败");
    }

    /**
     * 设置token提供者
     *
     * @param tokenSupplier token提供者
     */
    static void setTokenSupplier(Supplier<OAuthToken> tokenSupplier) {
        ClientTokenHolder.tokenSupplier = tokenSupplier;
    }
}
