package com.elitescloud.boot.auth.util;

import javax.validation.constraints.NotBlank;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;

/**
 * SDK工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/28
 */
public final class AuthSdkUtil {
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final MessageDigest digestSha256;

    static {
        try {
            digestSha256 = MessageDigest.getInstance("SHA-256");
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private AuthSdkUtil() {
    }

    /**
     * 生成验证码
     *
     * @return 验证码
     */
    public static String generateCodeVerifier() {
        int len = BASE_CHAR.length();
        Random random = new Random();
        StringBuilder stateBuilder = new StringBuilder();
        for (int i = 0; i < 10; i++) {
            stateBuilder.append(BASE_CHAR.charAt(random.nextInt(len)));
        }
        return stateBuilder.toString();
    }

    /**
     * 生成交换码
     *
     * @param codeVerifier 验证码
     * @return 交换码
     */
    public static String generateCodeChallenge(@NotBlank String codeVerifier) {
        byte[] bytes = digestSha256.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}
