/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.task.ClientTokenHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.common.OpenApiException;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RestTemplate;

public abstract class BaseTransferHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTransferHelper.class);
    private final RestTemplateHelper restTemplateHelper = RestTemplateHelper.instance((RestTemplate)RestTemplateFactory.instance(builder -> builder.rootUri(authServer).additionalInterceptors(new ClientHttpRequestInterceptor[]{new AuthorizationInterceptor()})));

    BaseTransferHelper(String authServer) {
    }

    <T> T nullToDefault(T obj, T defaultObj) {
        return obj == null ? defaultObj : obj;
    }

    <T> T remoteExchange(String url, HttpMethod httpMethod, HttpEntity<?> httpEntity, ParameterizedTypeReference<T> responseType, Object ... param) {
        try {
            return (T)this.restTemplateHelper.exchange(url, httpMethod, httpEntity, responseType, param);
        }
        catch (OpenApiException e) {
            if (e.getCode() == HttpStatus.UNAUTHORIZED.value()) {
                LOG.info("\u91cd\u8bd5\u8bf7\u6c42\uff1a{}", (Object)url);
                ClientTokenHolder.refresh();
                return (T)this.restTemplateHelper.exchange(url, httpMethod, httpEntity, responseType, param);
            }
            throw e;
        }
    }

    static class AuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        AuthorizationInterceptor() {
        }

        @NonNull
        public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
            HttpHeaders headers = request.getHeaders();
            OAuthToken token = ClientTokenHolder.getToken();
            if (token == null) {
                throw new IllegalStateException("Token\u83b7\u53d6\u5931\u8d25");
            }
            headers.add("Authorization", token.getTokenType() + " " + token.getAccessToken());
            return execution.execute(request, body);
        }
    }
}

