/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.AuthorizeCacheable;
import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientBO;
import com.elitescloud.boot.auth.cas.task.ClientTokenHolder;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.config.CloudtOAuth2Client;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import com.elitescloud.boot.auth.resolver.impl.DefaultUniquestResolver;
import com.elitescloud.boot.auth.util.AuthSdkUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2ClientProvider
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2ClientProvider.class);
    private final AuthorizationSdkProperties sdkProperties;
    private final AuthorizeCacheable authorizeCacheable;
    private final ObjectMapper objectMapper;
    private UniqueRequestResolver uniqueRequestResolver = new DefaultUniquestResolver("X-Auth-Cas-Client");
    private RestTemplate restTemplate;
    private OAuth2ClientBO clientBO;

    public OAuth2ClientProvider(AuthorizationSdkProperties sdkProperties, AuthorizeCacheable authorizeCacheable) {
        this.sdkProperties = sdkProperties;
        this.authorizeCacheable = authorizeCacheable == null ? new AuthorizeCacheDefault() : authorizeCacheable;
        this.objectMapper = ObjectMapperFactory.instance();
    }

    public String getAuthorizeInfo(@NotNull HttpServletResponse response, @NotBlank String redirectUrl, String state) {
        if (this.clientBO == null) {
            this.init();
        }
        String reqId = this.uniqueRequestResolver.signRequest(response);
        AuthorizeDTO authorizeDTO = new AuthorizeDTO();
        authorizeDTO.setAuthorizeEndpoint(this.clientBO.getAuthorizeEndpoint());
        authorizeDTO.setClientId(this.sdkProperties.getCasClient().getOauth2Client().getClientId());
        authorizeDTO.setResponseType("code");
        authorizeDTO.setScope("openid");
        authorizeDTO.setRedirectUri(redirectUrl);
        if (this.sdkProperties.getCasClient().getOauth2Client().isPkceEnabled()) {
            authorizeDTO.setCodeVerifier(AuthSdkUtil.generateCodeVerifier());
            authorizeDTO.setCodeChallengeMethod("S256");
            authorizeDTO.setCodeChallenge(AuthSdkUtil.generateCodeChallenge(authorizeDTO.getCodeVerifier()));
        }
        authorizeDTO.setState(state);
        this.authorizeCacheable.setCache(reqId, authorizeDTO);
        return authorizeDTO.getUrl();
    }

    public AuthorizeDTO getAuthorize(@NotNull HttpServletRequest request) {
        String reqId = this.uniqueRequestResolver.analyze(request);
        return this.authorizeCacheable.get(reqId);
    }

    public Result<OAuthToken> code2AccessToken(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotBlank String code) {
        String reqId = this.uniqueRequestResolver.analyze(request);
        AuthorizeDTO authorizeInfo = null;
        if (StringUtils.hasText((String)reqId)) {
            authorizeInfo = this.authorizeCacheable.get(reqId);
        }
        if (authorizeInfo == null) {
            LOG.info("\u83b7\u53d6\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff1a{}\uff0c\u6216\u5df2\u8d85\u65f6", (Object)reqId);
            throw new OAuth2AuthenticationException("\u8ba4\u8bc1\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
        }
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)authorizeInfo.getClientId());
        postParam.add((Object)"client_secret", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientSecret());
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
        postParam.add((Object)"code", (Object)code);
        String redirectUri = authorizeInfo.getRedirectUri();
        if (StringUtils.hasText((String)redirectUri)) {
            postParam.add((Object)"redirect_uri", (Object)redirectUri);
        }
        if (StringUtils.hasText((String)authorizeInfo.getCodeVerifier())) {
            postParam.add((Object)"code_verifier", (Object)authorizeInfo.getCodeVerifier());
        }
        return this.executeWithRetry(() -> this.lambda$code2AccessToken$0((MultiValueMap)postParam, response, reqId));
    }

    public Result<HashMap<String, String>> queryUserInfo(@NotBlank String tokenType, @NotBlank String accessToken) {
        Assert.hasText((String)tokenType, (String)"token\u7c7b\u578b\u4e3a\u7a7a");
        Assert.hasText((String)accessToken, (String)"token\u4e3a\u7a7a");
        LinkedMultiValueMap headers = new LinkedMultiValueMap(4);
        headers.add((Object)"Authorization", (Object)(tokenType + " " + accessToken));
        return this.executeWithRetry(() -> this.lambda$queryUserInfo$1((MultiValueMap)headers, tokenType, accessToken));
    }

    public Result<OAuthToken> refreshToken(@NotBlank String refreshToken) {
        Assert.notNull((Object)refreshToken, (String)"\u5237\u65b0token\u4e3a\u7a7a");
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientId());
        postParam.add((Object)"client_secret", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientSecret());
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.REFRESH_TOKEN.getValue());
        postParam.add((Object)"refresh_token", (Object)refreshToken);
        return this.executeWithRetry(() -> this.lambda$refreshToken$2((MultiValueMap)postParam));
    }

    public Result<OAuthToken> clientToken() {
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"grant_type", (Object)AuthorizationGrantType.CLIENT_CREDENTIALS.getValue());
        postParam.add((Object)"client_id", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientId());
        postParam.add((Object)"client_secret", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientSecret());
        try {
            ResponseEntity resp = this.restTemplate.exchange(this.clientBO.getTokenEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthToken>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return Result.ok((OAuthToken)resp.getBody());
            }
            LOG.error("\u751f\u6210token\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25");
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff1a", (Throwable)e);
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25\uff01");
        }
    }

    public Result<Boolean> revokeToken(@NotBlank String token) {
        Assert.hasText((String)token, (String)"token\u4e3a\u7a7a");
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"client_id", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientId());
        postParam.add((Object)"client_secret", (Object)this.sdkProperties.getCasClient().getOauth2Client().getClientSecret());
        postParam.add((Object)"token", (Object)token);
        try {
            ResponseEntity resp = this.restTemplate.exchange(this.clientBO.getRevocationEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return Result.ok(true);
            }
            LOG.error("\u6ce8\u9500token\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
            return Result.fail("\u6ce8\u9500token\u5931\u8d25");
        }
        catch (Exception e) {
            LOG.error("\u6ce8\u9500token\u5931\u8d25\uff1a", (Throwable)e);
            return Result.fail("\u6ce8\u9500token\u5931\u8d25\uff01");
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.sdkProperties.getCasClient().getOauth2Client().isPkceEnabled()) {
            Assert.hasText((String)this.sdkProperties.getCasClient().getOauth2Client().getClientSecret(), (String)"OAuth2 Client\u7684clientSecret\u4e3a\u7a7a");
        }
        CompletableFuture.runAsync(this::init).whenComplete((res, exp) -> {
            if (exp != null) {
                LOG.error("\u521d\u59cb\u5316OAuth2\u5ba2\u6237\u7aef\u5f02\u5e38\uff1a", exp);
            }
        });
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }

    private <T extends Serializable> Result<T> executeWithRetry(Supplier<Result<T>> supplier) {
        Result<T> result = null;
        try {
            result = supplier.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null && Boolean.TRUE.equals(result.getSuccess())) {
            return result;
        }
        Result<OAuthToken> tokenResult = this.clientToken();
        if (tokenResult != null) {
            ClientTokenHolder.setToken(tokenResult.getData());
        }
        try {
            return supplier.get();
        }
        catch (Exception e) {
            LOG.error("\u8bf7\u6c42\u8ba4\u8bc1\u6388\u6743\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    private void init() {
        if (this.restTemplate == null) {
            this.restTemplate = RestTemplateFactory.instance();
        }
        this.initClient();
    }

    private void initClient() {
        String authServer = this.obtainAuthServer();
        this.clientBO = this.initClient(authServer);
    }

    private String obtainAuthServer() {
        return this.sdkProperties.getAuthServer();
    }

    private OAuth2ClientBO initClient(String authServer) {
        OAuth2ClientBO client = new OAuth2ClientBO();
        CloudtOAuth2Client clientProperties = this.sdkProperties.getCasClient().getOauth2Client();
        client.setAuthorizeEndpoint(this.normalizeUrl(authServer, clientProperties.getAuthorizeEndpoint()));
        client.setTokenEndpoint(this.normalizeUrl(authServer, clientProperties.getTokenEndpoint()));
        client.setUserinfoEndpoint(this.normalizeUrl(authServer, clientProperties.getUserinfoEndpoint()));
        Assert.hasText((String)authServer, (String)"\u672a\u77e5\u8ba4\u8bc1\u670d\u52a1\u5668\u5730\u5740");
        Map<String, Object> queryResult = this.queryServerConfig(this.normalizeUrl(authServer, "/.well-known/openid-configuration"));
        client.setAuthorizeEndpoint(this.blankToDefault(client.getAuthorizeEndpoint(), (String)queryResult.get("authorization_endpoint")));
        Assert.hasText((String)client.getAuthorizeEndpoint(), (String)"OAuth2\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25");
        client.setTokenEndpoint(this.blankToDefault(client.getTokenEndpoint(), (String)queryResult.get("token_endpoint")));
        client.setUserinfoEndpoint(this.blankToDefault(client.getUserinfoEndpoint(), (String)queryResult.get("userinfo_endpoint")));
        client.setRevocationEndpoint((String)queryResult.get("revocation_endpoint"));
        return client;
    }

    private Map<String, Object> queryServerConfig(String url) {
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                LOG.info("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u6210\u529f\uff1a{}", resp.getBody());
                return (Map)resp.getBody();
            }
            LOG.warn("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)resp.getStatusCode());
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2OAuth2\u670d\u52a1\u7aef\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private String normalizeUrl(String authServer, String uri) {
        if (!StringUtils.hasText((String)uri)) {
            return null;
        }
        if (uri.toLowerCase().startsWith("http")) {
            return UriComponentsBuilder.fromUriString((String)uri).toUriString();
        }
        authServer = authServer == null ? "" : authServer;
        return UriComponentsBuilder.fromUriString((String)(authServer + "/" + uri)).toUriString();
    }

    private String blankToDefault(String value, String defaultValue) {
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return defaultValue;
    }

    private /* synthetic */ Result lambda$refreshToken$2(MultiValueMap postParam) {
        try {
            ResponseEntity resp = this.restTemplate.exchange(this.clientBO.getTokenEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthToken>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return Result.ok((OAuthToken)resp.getBody());
            }
            LOG.error("\u5237\u65b0token\u5931\u8d25\uff1a{}", (Object)resp);
            return Result.fail("\u5237\u65b0token\u5931\u8d25");
        }
        catch (Exception e) {
            LOG.error("\u5237\u65b0\u8ba4\u8bc1token\u5f02\u5e38\uff1a", (Throwable)e);
            return Result.fail("\u5237\u65b0\u8ba4\u8bc1token\u5f02\u5e38\uff01");
        }
    }

    private /* synthetic */ Result lambda$queryUserInfo$1(MultiValueMap headers, String tokenType, String accessToken) {
        try {
            ResponseEntity resp = this.restTemplate.exchange(this.clientBO.getUserinfoEndpoint(), HttpMethod.GET, new HttpEntity(null, headers), (ParameterizedTypeReference)new ParameterizedTypeReference<HashMap<String, String>>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return Result.ok((HashMap)resp.getBody());
            }
            LOG.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0ctoken\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", (Object)(tokenType + " " + accessToken), (Object)resp);
            return Result.fail("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff0ctoken:{}\uff0c\u5f02\u5e38\uff1a", (Object)(tokenType + " " + accessToken), (Object)e);
            return Result.fail("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
        }
    }

    private /* synthetic */ Result lambda$code2AccessToken$0(MultiValueMap postParam, HttpServletResponse response, String reqId) {
        try {
            ResponseEntity resp = this.restTemplate.exchange(this.clientBO.getTokenEndpoint(), HttpMethod.POST, new HttpEntity((Object)postParam), (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthToken>(){}, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                this.uniqueRequestResolver.clear(response, reqId);
                return Result.ok((OAuthToken)resp.getBody());
            }
            LOG.error("\u6388\u6743\u7801\u8f6ctoken\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u54cd\u5e94\uff1a{}", (Object)this.objectMapper.writeValueAsString((Object)postParam), (Object)resp);
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5931\u8d25");
        }
        catch (Exception e) {
            try {
                LOG.error("\u83b7\u53d6\u8ba4\u8bc1token\u5f02\u5e38\uff0c\u53c2\u6570\uff1a" + this.objectMapper.writeValueAsString((Object)postParam) + ", \uff1a", (Throwable)e);
            }
            catch (JsonProcessingException ex) {
                LOG.error("\u83b7\u53d6\u8ba4\u8bc1token\u5f02\u5e38\uff0c\u6253\u5370\u5165\u53c2\u5f02\u5e38\uff0c", (Throwable)e);
            }
            return Result.fail("\u83b7\u53d6\u8ba4\u8bc1token\u5f02\u5e38\uff01");
        }
    }

    static class AuthorizeCacheDefault
    implements AuthorizeCacheable {
        private final Cache<String, AuthorizeDTO> authorizeCache = Caffeine.newBuilder().maximumSize(2000L).expireAfterWrite(Duration.ofMinutes(60L)).build();

        @Override
        public void setCache(String reqId, AuthorizeDTO authorizeDTO) {
            this.authorizeCache.put((Object)reqId, (Object)authorizeDTO);
        }

        @Override
        public AuthorizeDTO get(String reqId) {
            return (AuthorizeDTO)this.authorizeCache.getIfPresent((Object)reqId);
        }
    }
}

