/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.model.AuthClientUserDTO;
import com.elitescloud.boot.auth.cas.provider.BaseTransferHelper;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.authorization.sdk.model.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public class UserTransferHelper
extends BaseTransferHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UserTransferHelper.class);
    private static com.elitescloud.cloudt.authorization.sdk.cas.provider.UserTransferHelper transferHelper = null;

    protected UserTransferHelper(String authServer) {
        super(authServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.elitescloud.cloudt.authorization.sdk.cas.provider.UserTransferHelper getInstance(@NotBlank String authServer) {
        Class<UserTransferHelper> clazz = UserTransferHelper.class;
        synchronized (UserTransferHelper.class) {
            if (transferHelper == null) {
                transferHelper = new com.elitescloud.cloudt.authorization.sdk.cas.provider.UserTransferHelper(authServer);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return transferHelper;
        }
    }

    public Result<Long> upsertUser(@NotNull AuthUserDTO userInfo) {
        Assert.notNull((Object)userInfo, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u8d26\u53f7\uff1a{}", (Object)userInfo.getUsername());
        return this.remoteExchange("/rpc/cloudt/authorization/user/upsertUser", HttpMethod.POST, new HttpEntity((Object)userInfo), new ParameterizedTypeReference<Result<Long>>(){}, new Object[0]);
    }

    public Result<HashMap<String, Long>> upsertUserBatch(boolean rollBackAllOnException, @NotEmpty List<AuthUserDTO> userInfoList) {
        Assert.notEmpty(userInfoList, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u8d26\u53f7\uff1a{}", userInfoList.stream().map(com.elitescloud.boot.auth.cas.model.AuthUserDTO::getUsername).collect(Collectors.toList()));
        return this.remoteExchange("/rpc/cloudt/authorization/user/upsertUser/batch?rollBackAllOnException={rollBackAllOnException}", HttpMethod.POST, new HttpEntity(userInfoList), new ParameterizedTypeReference<Result<HashMap<String, Long>>>(){}, rollBackAllOnException);
    }

    public Result<Long> updateEnabled(long userId, boolean enabled) {
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u8d26\u53f7\u72b6\u6001\uff1a{}, {}", (Object)userId, (Object)enabled);
        return this.remoteExchange("/rpc/cloudt/authorization/user/update/enabled?userId={userId}&enabled={enabled}", HttpMethod.PATCH, null, new ParameterizedTypeReference<Result<Long>>(){}, userId, enabled);
    }

    public Result<Long> updatePassword(long userId, @NotBlank String pd) {
        Assert.hasText((String)pd, (String)"\u5bc6\u7801\u4e3a\u7a7a");
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u8d26\u53f7\u5bc6\u7801\uff1a{}, {}", (Object)userId, (Object)pd);
        return this.remoteExchange("/rpc/cloudt/authorization/user/update/pwd?userId={userId}&pd={pd}", HttpMethod.PATCH, null, new ParameterizedTypeReference<Result<Long>>(){}, userId, pd);
    }

    public Result<Long> updateMobile(long userId, String mobile) {
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u624b\u673a\u53f7\uff1a{}, {}", (Object)userId, (Object)mobile);
        return this.remoteExchange("/rpc/cloudt/authorization/user/update/mobile?id={id}&mobile={mobile}", HttpMethod.PATCH, null, new ParameterizedTypeReference<Result<Long>>(){}, userId, mobile);
    }

    public Result<Long> updateEmail(long userId, String email) {
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u90ae\u7bb1\uff1a{}, {}", (Object)userId, (Object)email);
        return this.remoteExchange("/rpc/cloudt/authorization/user/update/email?id={id}&email={email}", HttpMethod.PATCH, null, new ParameterizedTypeReference<Result<Long>>(){}, userId, email);
    }

    public Result<Long> updateExpiredTime(long userId, @NotBlank String expiredTime) {
        Assert.hasText((String)expiredTime, (String)"\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u8d26\u53f7\u8fc7\u671f\u65f6\u95f4\uff1a{}, {}", (Object)userId, (Object)expiredTime);
        return this.remoteExchange("/rpc/cloudt/authorization/user/update/expiredTime?userId={userId}&expiredTime={expiredTime}", HttpMethod.PATCH, null, new ParameterizedTypeReference<Result<Long>>(){}, userId, expiredTime);
    }

    public Result<Long> updatePwdExpiredTime(long userId, String expiredTime) {
        Assert.hasText((String)expiredTime, (String)"\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65\u5bc6\u7801\u8fc7\u671f\u65f6\u95f4\uff1a{}, {}", (Object)userId, (Object)expiredTime);
        return this.remoteExchange("/rpc/cloudt/authorization/user/update/pwd/expiredTime?userId={userId}&expiredTime={expiredTime}", HttpMethod.PATCH, null, new ParameterizedTypeReference<Result<Long>>(){}, userId, expiredTime);
    }

    public Result<Long> delete(long userId) {
        LOG.info("\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u5220\u9664\u8d26\u53f7\uff1a{}", (Object)userId);
        return this.remoteExchange("/rpc/cloudt/authorization/user/delete?userId={userId}", HttpMethod.DELETE, null, new ParameterizedTypeReference<Result<Long>>(){}, userId);
    }

    public Result<AuthUserDTO> getUser(long userId) {
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUser?userId={userId}", HttpMethod.GET, null, new ParameterizedTypeReference<Result<AuthUserDTO>>(){}, userId);
    }

    public Result<AuthUserDTO> getUserByUsername(@NotBlank String username) {
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUserByUsername?username={username}", HttpMethod.GET, null, new ParameterizedTypeReference<Result<AuthUserDTO>>(){}, username);
    }

    public Result<AuthUserDTO> getUserByMobile(@NotBlank String mobile) {
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUserByMobile?mobile={mobile}", HttpMethod.GET, null, new ParameterizedTypeReference<Result<AuthUserDTO>>(){}, mobile);
    }

    public Result<AuthUserDTO> getUserByEmail(@NotBlank String email) {
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUserByEmail?email={email}", HttpMethod.GET, null, new ParameterizedTypeReference<Result<AuthUserDTO>>(){}, email);
    }

    public Result<ArrayList<AuthUserDTO>> getUserList(@NotEmpty List<Long> userIds) {
        Assert.notEmpty(userIds, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUserList", HttpMethod.POST, new HttpEntity(userIds), new ParameterizedTypeReference<Result<ArrayList<AuthUserDTO>>>(){}, new Object[0]);
    }

    public Result<HashMap<String, Long>> getUserIdByUsername(@NotEmpty List<String> usernames) {
        Assert.notEmpty(usernames, (String)"\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a");
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUserIdByUsername", HttpMethod.POST, new HttpEntity(usernames), new ParameterizedTypeReference<Result<HashMap<String, Long>>>(){}, new Object[0]);
    }

    public Result<HashMap<String, Long>> getUserIdByMobile(@NotEmpty List<String> mobiles) {
        Assert.notEmpty(mobiles, (String)"\u7528\u6237\u8d26\u53f7\u4e3a\u7a7a");
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUserIdByMobile", HttpMethod.POST, new HttpEntity(mobiles), new ParameterizedTypeReference<Result<HashMap<String, Long>>>(){}, new Object[0]);
    }

    public Result<HashMap<String, Long>> getUserIdByEmail(@NotEmpty List<String> emails) {
        Assert.notEmpty(emails, (String)"\u90ae\u7bb1\u4e3a\u7a7a");
        return this.remoteExchange("/rpc/cloudt/authorization/user/getUserIdByEmail", HttpMethod.POST, new HttpEntity(emails), new ParameterizedTypeReference<Result<HashMap<String, Long>>>(){}, new Object[0]);
    }

    public com.elitescloud.boot.auth.model.Result<AuthClientUserDTO> validateClientUser(String clientId, Long userId) {
        return this.remoteExchange("/rpc/cloudt/authorization/user/validateClientUser?clientId={clientId}&userId={userId}", HttpMethod.GET, null, new ParameterizedTypeReference<com.elitescloud.boot.auth.model.Result<AuthClientUserDTO>>(){}, clientId == null ? "" : clientId, userId == null ? "" : userId);
    }
}

