/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.cas.provider.OAuth2ClientProvider;
import com.elitescloud.boot.auth.cas.task.ClientTokenHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.model.Result;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRefreshClientTokenTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshClientTokenTask.class);
    private static final int MAX_RETRY_TIMES = 5;
    private final OAuth2ClientProvider oAuth2ClientProvider;

    public AutoRefreshClientTokenTask(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
        ClientTokenHolder.setTokenSupplier(() -> oAuth2ClientProvider.clientToken().getData());
    }

    @Override
    public void run() {
        boolean result = this.execute();
        if (result) {
            return;
        }
        for (int retryTimes = 0; retryTimes < 5; ++retryTimes) {
            try {
                TimeUnit.MINUTES.sleep(retryTimes + 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.info("\u7b2c{}\u6b21\u5c1d\u8bd5\u91cd\u65b0\u83b7\u53d6\u5ba2\u6237\u7aeftoken", (Object)retryTimes);
            result = this.execute();
            if (result) break;
        }
    }

    private boolean execute() {
        Result<OAuthToken> tokenResult = this.oAuth2ClientProvider.clientToken();
        if (Boolean.TRUE.equals(tokenResult.getSuccess())) {
            ClientTokenHolder.setToken(tokenResult.getData());
            LOG.info("\u5ba2\u6237\u7aeftoken\u5237\u65b0\uff1a{}", (Object)tokenResult.getData());
            return true;
        }
        LOG.error("CAS\u5ba2\u6237\u7aeftoken\u83b7\u53d6\u5931\u8d25\uff1a{}", tokenResult);
        return false;
    }
}

