package com.elitescloud.boot.auth.cas.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

/**
 * 用户信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/19
 */
public class OAuth2UserInfoDTO implements Serializable {
    private static final long serialVersionUID = 6871996104128564436L;

    /**
     * 登录号
     */
    @JsonProperty(value = "sub")
    private String username;

    /**
     * 认证中心用户ID
     */
    @JsonProperty(value = "cloudt_ui")
    private Long casUserId;

    /**
     * 姓名
     */
    @JsonProperty(value = "name")
    private String fullName;

    /**
     * 手机号
     */
    @JsonProperty(value = "phone_number")
    private String mobile;

    /**
     * 邮箱
     */
    @JsonProperty(value = "email")
    private String email;

    /**
     * 登录终端
     */
    @JsonProperty(value = "cloudt_tl")
    private String terminal;

    /**
     * 用户类型
     */
    @JsonProperty(value = "cloudt_ut")
    private String userType;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getCasUserId() {
        return casUserId;
    }

    public void setCasUserId(Long casUserId) {
        this.casUserId = casUserId;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTerminal() {
        return terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }
}
