package com.elitescloud.boot.auth.cas.model.login;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 登录日志.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/6
 */
public class AuthLoginLogDTO implements Serializable {
    private static final long serialVersionUID = -4420173923269301798L;

    /**
     * 记录标识，日志ID
     */
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 登录时间
     */
    private LocalDateTime loginTime;

    /**
     * 是否登录成功
     */
    private Boolean success;

    /**
     * 登录IP
     */
    private String ip;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public LocalDateTime getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(LocalDateTime loginTime) {
        this.loginTime = loginTime;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}
