package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.model.Result;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

import javax.validation.constraints.NotBlank;

/**
 * 客户度助手.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/29
 */
public class ClientTransferHelper extends BaseTransferHelper {
    private static ClientTransferHelper instance = null;

    public ClientTransferHelper(String authServer) {
        super(authServer);
    }

    public static ClientTransferHelper getInstance(@NotBlank String authServer) {
        if (instance == null) {
            synchronized (ClientTransferHelper.class) {
                if (instance == null) {
                    instance = new ClientTransferHelper(authServer);
                }
            }
        }
        return instance;
    }

    /**
     * 验证客户端
     *
     * @param clientId     客户端ID
     * @param clientSecret 客户端密码
     * @return 验证结果
     */
    public Result<Boolean> validateClient(@NotBlank String clientId, @NotBlank String clientSecret) {
        Assert.hasText(clientId, "客户端ID不能为空");
        Assert.hasText(clientSecret, "客户端密码不能为空");
        return remoteExchange(CasUrlConstant.URI_CLIENT_VALIDATE, HttpMethod.GET, null,
                new TypeReference<>() {
                }, clientId, clientSecret);
    }
}
