package com.elitescloud.boot.auth.model;

import java.io.Serializable;
import java.util.Date;

/**
 * 接口返回结果.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/15
 */
public class Result<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = 6123408629576125416L;

    private String msg;
    private Boolean success;
    private T data;

    private Date time;

    public static <T extends Serializable>Result<T> fail(String msg) {
        Result<T> result = new Result<>();
        result.setMsg(msg);
        result.setSuccess(false);
        result.setTime(new Date());
        return result;
    }

    public static <T extends Serializable>Result<T> ok(T body) {
        Result<T> result = new Result<>();
        result.setSuccess(true);
        result.setTime(new Date());
        result.setData(body);
        return result;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public String toString() {
        return "Result{" +
                "msg='" + msg + '\'' +
                ", success=" + success +
                ", data=" + data +
                ", time=" + time +
                '}';
    }
}
