package com.elitescloud.boot.auth.sso.common;

import com.elitescloud.boot.auth.sso.model.UserInfoDTO;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

/**
 * sso authentication.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/18
 */
public class TicketAuthentication extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -5255199839939355987L;

    private final String ticket;
    private final UserInfoDTO userInfoDTO;
    private Serializable token;
    private Object principal;

    public TicketAuthentication(String ticket, UserInfoDTO userInfoDTO) {
        super(Collections.emptyList());
        this.ticket = ticket;
        this.userInfoDTO = userInfoDTO;
        super.setAuthenticated(false);
    }

    public TicketAuthentication(String ticket, UserInfoDTO userInfoDTO, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.ticket = ticket;
        this.userInfoDTO = userInfoDTO;
        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return ticket;
    }

    @Override
    public Object getPrincipal() {
        return principal;
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    public void setToken(Serializable token) {
        this.token = token;
    }

    public String getTicket() {
        return ticket;
    }

    public Serializable getToken() {
        return token;
    }

    public UserInfoDTO getUserInfoDTO() {
        return userInfoDTO;
    }
}
