package com.elitescloud.boot.auth.cas.common;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 策略类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/13
 */
public enum PwdStrategyTypeEnum {

    /**
     * 修改密码时
     */
    PWD_UPDATE,
    /**
     * 登录时
     */
    LOGIN;

    private static final Map<String, PwdStrategyTypeEnum> ALL = Arrays.stream(PwdStrategyTypeEnum.values())
           .collect(Collectors.toMap(PwdStrategyTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析密码策略
     *
     * @param value 策略名称
     * @return 策略
     */
    public static PwdStrategyTypeEnum parse(String value) {
        if (value == null) {
            return null;
        }
        return ALL.get(value);
    }
}
