package com.elitescloud.boot.auth.cas.model.pwd;

import com.elitescloud.boot.auth.cas.common.PwdRecordTypeEnum;
import com.elitescloud.boot.auth.model.UpdaterInfoDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 修改密码信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/9
 */
public class AuthPwdUpdateDTO implements Serializable {
    private static final long serialVersionUID = 5345950566650728279L;

    /**
     * 操作人信息
     */
    private UpdaterInfoDTO updaterInfo;

    /**
     * 用户ID
     * <p>
     * 认证服务的用户ID
     */
    @NotNull(message = "用户ID为空")
    private Long userId;

    /**
     * 新密码
     * <p>
     * 明文密码
     */
    @NotBlank(message = "密码为空")
    private String password;

    /**
     * 修改类型
     */
    private PwdRecordTypeEnum updateType;

    public UpdaterInfoDTO getUpdaterInfo() {
        return updaterInfo;
    }

    public void setUpdaterInfo(UpdaterInfoDTO updaterInfo) {
        this.updaterInfo = updaterInfo;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PwdRecordTypeEnum getUpdateType() {
        return updateType;
    }

    public void setUpdateType(PwdRecordTypeEnum updateType) {
        this.updateType = updateType;
    }
}
