/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.common.PwdStrategyTypeEnum;
import com.elitescloud.boot.auth.cas.model.UserDetailExtendDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategyConfigDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategyDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategySaveDTO;
import com.elitescloud.boot.auth.cas.provider.BaseTransferHelper;
import com.elitescloud.boot.auth.model.Result;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PwdStrategyTransferHelper
extends BaseTransferHelper {
    private static PwdStrategyTransferHelper instance = null;

    private PwdStrategyTransferHelper(String authServer) {
        super(authServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PwdStrategyTransferHelper getInstance(@NotBlank String authServer) {
        if (instance != null) return instance;
        Class<PwdStrategyTransferHelper> clazz = PwdStrategyTransferHelper.class;
        synchronized (PwdStrategyTransferHelper.class) {
            if (instance != null) return instance;
            instance = new PwdStrategyTransferHelper(authServer);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public Result<AuthPwdStrategyConfigDTO> get() {
        return this.remoteExchangeCacheable("/rpc/cloudt/authorization/pwdStrategy/get", HttpMethod.GET, null, new TypeReference<Result<AuthPwdStrategyConfigDTO>>(){}, new Object[0]);
    }

    public Result<AuthPwdStrategyConfigDTO> getDefault() {
        return this.remoteExchangeCacheable("/rpc/cloudt/authorization/pwdStrategy/getDefault", HttpMethod.GET, null, new TypeReference<Result<AuthPwdStrategyConfigDTO>>(){}, new Object[0]);
    }

    public Result<Boolean> save(List<AuthPwdStrategySaveDTO> saveDTOList) {
        this.clearCache();
        return this.remoteExchange("/rpc/cloudt/authorization/pwdStrategy/save", HttpMethod.POST, new HttpEntity(saveDTOList), new TypeReference<Result<Boolean>>(){}, new Object[0]);
    }

    public Result<ArrayList<AuthPwdStrategyDTO>> listByType(PwdStrategyTypeEnum type) {
        return this.remoteExchangeCacheable("/rpc/cloudt/authorization/pwdStrategy/listByType?type={type}", HttpMethod.GET, null, new TypeReference<Result<ArrayList<AuthPwdStrategyDTO>>>(){}, type == null ? "" : type.name());
    }

    public Result<String> verifyPassword(Long userId, String username, @NotBlank String password) {
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.remoteExchangeCacheable("/rpc/cloudt/authorization/pwdStrategy/verify?userId={userId}&username={username}&p={p}", HttpMethod.GET, null, new TypeReference<Result<String>>(){}, userId == null ? "" : userId, StringUtils.hasText((String)username) ? username : "", password);
    }

    public Result<UserDetailExtendDTO> getLoginUserDetailExtend(@NotNull Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        return this.remoteExchangeCacheable("/rpc/cloudt/authorization/pwdStrategy/userDetailExtend?userId={userId}", HttpMethod.GET, null, new TypeReference<Result<UserDetailExtendDTO>>(){}, userId);
    }
}

