/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.task;

import com.elitescloud.boot.auth.model.OAuthToken;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTokenHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTokenHolder.class);
    private static volatile OAuthToken token;
    private static Supplier<OAuthToken> tokenSupplier;

    private ClientTokenHolder() {
    }

    public static void setToken(OAuthToken token) {
        ClientTokenHolder.token = token;
    }

    public static OAuthToken getToken() {
        if (token == null && tokenSupplier != null) {
            token = tokenSupplier.get();
        }
        return token;
    }

    public static boolean hasToken() {
        return token != null;
    }

    public static void refresh() {
        if (tokenSupplier != null) {
            token = tokenSupplier.get();
            LOG.info("client token\u5237\u65b0\u6210\u529f");
            return;
        }
        LOG.info("client token\u5237\u65b0\u5931\u8d25");
    }

    static void setTokenSupplier(Supplier<OAuthToken> tokenSupplier) {
        ClientTokenHolder.tokenSupplier = tokenSupplier;
    }
}

