package com.elitescloud.boot.auth.client.client.config.filter;

import cn.hutool.core.util.BooleanUtil;
import com.elitescloud.boot.auth.client.client.config.OAuthClientProperties;
import com.elitescloud.boot.auth.client.client.service.OAuthClientUserService;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 客户端token过滤器.
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/22
 */
public class OAuthClientTokenFilter extends OncePerRequestFilter {

    private final OAuthClientProperties oauthClientProperties;
    private final OAuthClientUserService userService;
    private final RequestMatcher pathMatcher;

    public OAuthClientTokenFilter(OAuthClientProperties oauthClientProperties, OAuthClientUserService userService) {
        this.oauthClientProperties = oauthClientProperties;
        this.userService = userService;
        pathMatcher = new AntPathRequestMatcher(oauthClientProperties.getPath());
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!BooleanUtil.isTrue(oauthClientProperties.getEnabled())) {
            // 未启用
            filterChain.doFilter(request, response);
            return;
        }

        if (!pathMatcher.matches(request)) {
            // 不匹配的放行
            filterChain.doFilter(request, response);
            return;
        }

        // 获取token
        userService.grantToken(request, response);
    }
}
