package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

import java.time.Duration;

/**
 * Authentication缓存.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/1
 */
public interface AuthenticationCache {

    /**
     * 缓存用户信息
     *
     * @param key        缓存key
     * @param user       用户信息
     * @param timeToLive 缓存时间
     */
    void setUserDetail(@NonNull String key, @NonNull GeneralUserDetails user, Duration timeToLive);

    /**
     * 从缓存获取用户信息
     *
     * @param key 缓存key
     * @return 用户信息
     */
    @Nullable
    GeneralUserDetails getUserDetail(@NonNull String key);

    /**
     * 移除缓存中用户信息
     *
     * @param key 缓存key
     */
    void removeUserDetail(@NonNull String key);
}
