package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.boot.auth.client.common.SecurityConstants;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import lombok.extern.log4j.Log4j2;
import org.springframework.lang.NonNull;

import java.time.Duration;

/**
 * redis身份认证缓存.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/2
 */
@Log4j2
public class RedisAuthenticationCache implements AuthenticationCache {

    private final RedisHelper redisHelper;

    public RedisAuthenticationCache(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    @Override
    public void setUserDetail(@NonNull String key, @NonNull GeneralUserDetails user, Duration timeToLive) {
        try {
            redisHelper.execute(redisUtils -> {
                String cacheKey = generateCacheKey(key);
                if (timeToLive != null) {
                    redisUtils.set(cacheKey, user, timeToLive.toSeconds());
                    return null;
                }

                redisUtils.set(cacheKey, user);
                return null;
            });
        } catch (Exception e) {
            throw new BusinessException("缓存用户详细信息失败", e);
        }
    }

    @Override
    public GeneralUserDetails getUserDetail(@NonNull String key) {
        try {
            return redisHelper.execute(redisUtils -> {
                String cacheKey = generateCacheKey(key);
                return (GeneralUserDetails) redisUtils.get(cacheKey);
            });
        } catch (Exception e) {
            throw new BusinessException("获取用户详细信息失败", e);
        }
    }

    @Override
    public void removeUserDetail(String key) {
        try {
            redisHelper.execute(redisUtils -> {
                String cacheKey = generateCacheKey(key);
                redisUtils.del(cacheKey);

                return null;
            });
        } catch (Exception e) {
            throw new BusinessException("删除用户详细信息失败", e);
        }
    }

    private String generateCacheKey(String cacheKey) {
        return SecurityConstants.CACHE_PREFIX_CURRENT_USER + cacheKey;
    }
}
