/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.client.service;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.boot.auth.client.client.OAuthUserProvider;
import com.elitescloud.boot.auth.client.client.config.OAuthClientProperties;
import com.elitescloud.boot.auth.client.client.service.AuthServerRequestHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.CacheControl;

public class OAuthClientUserService {
    private static final Logger log = LogManager.getLogger(OAuthClientUserService.class);
    private final OAuthClientProperties oauthClientProperties;
    private final OAuthUserProvider userProvider;
    private final ObjectMapper objectMapper;
    private final AuthServerRequestHolder authServerRequestHolder;
    private static final String PARAM_CLIENT = "_c";

    public OAuthClientUserService(OAuthClientProperties oauthClientProperties, OAuthUserProvider userService, ObjectMapper objectMapper, AuthServerRequestHolder authServerRequestHolder) {
        this.oauthClientProperties = oauthClientProperties;
        this.userProvider = userService;
        this.objectMapper = objectMapper;
        this.authServerRequestHolder = authServerRequestHolder;
    }

    public void grantToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean authenticated;
        Map reqParam = ServletUtil.getParamMap((ServletRequest)request);
        log.info("Oauth Client Token\u8bf7\u6c42\uff1a" + this.objectMapper.writeValueAsString((Object)reqParam));
        try {
            authenticated = this.userProvider.authenticate(reqParam);
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                log.info("Oauth Client\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff1a{}", (Object)e.getMessage());
                this.writeBusinessException(response, e);
                return;
            }
            log.error("Oauth Client\u8ba4\u8bc1\u5f02\u5e38\uff1a", (Throwable)e);
            this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.SYSTEM_EXCEPTION));
            return;
        }
        if (!authenticated) {
            this.writeResponse(response, ApiResult.fail((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8bf7\u786e\u8ba4\u7528\u6237\u72b6\u6001\u662f\u5426\u6b63\u5e38"));
            return;
        }
        String username = null;
        try {
            username = this.loadUser();
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                log.info("\u83b7\u53d6\u8ba4\u8bc1\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                this.writeBusinessException(response, e);
                return;
            }
            log.error("\u83b7\u53d6\u8ba4\u8bc1\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            this.writeResponse(response, ApiResult.fail((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8bf7\u786e\u8ba4\u7528\u6237\u72b6\u6001\u662f\u5426\u6b63\u5e38"));
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)username)) {
            this.writeResponse(response, ApiResult.fail((String)"\u9881\u53d1token\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u6709\u6548\u7528\u6237\u4fe1\u606f"));
            return;
        }
        this.generateToken(response, reqParam, username);
    }

    private void writeBusinessException(HttpServletResponse response, Exception e) throws IOException {
        BusinessException eb = (BusinessException)e;
        ApiResult result = ApiResult.fail((ApiCode)(eb.getCode() == null ? ApiCode.SYSTEM_EXCEPTION : eb.getApiCode()), (String)eb.getMessage());
        this.writeResponse(response, result);
    }

    private void generateToken(HttpServletResponse response, Map<String, String> reqParam, String username) throws IOException {
        log.info("\u4e3a\u7528\u6237\u3010{}\u3011\u751f\u6210token", (Object)username);
        ApiResult tokenResult = (ApiResult)this.authServerRequestHolder.getAccessToken(username, this.userProvider.terminal()).block();
        this.writeResponse(response, tokenResult);
    }

    private String loadUser() {
        String user = this.userProvider.obtainUser();
        if (user != null) {
            return user;
        }
        return this.oauthClientProperties.getSpecifiedUser();
    }

    private void writeResponse(HttpServletResponse response, ApiResult<?> result) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        response.setContentType("application/json");
        response.setHeader("Cache-Control", CacheControl.noCache().getHeaderValue());
        response.setHeader("Pragma", CacheControl.noStore().getHeaderValue());
        PrintWriter writer = response.getWriter();
        ObjectWriter prettyPrinter = this.objectMapper.writerWithDefaultPrettyPrinter();
        try {
            writer.write(prettyPrinter.writeValueAsString(result));
        }
        catch (JsonProcessingException e) {
            writer.write(prettyPrinter.writeValueAsString((Object)ApiResult.fail((ApiCode)ApiCode.FAIL)));
        }
        writer.flush();
        writer.close();
    }
}

