/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.boot.web.exception.GlobalExceptionHandler;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={GlobalExceptionHandler.class})
class AuthorizationExceptionAutoConfiguration {
    private static final Logger log = LogManager.getLogger(AuthorizationExceptionAutoConfiguration.class);

    AuthorizationExceptionAutoConfiguration() {
    }

    @Bean
    public CustomExceptionTranslate authorizationExceptionTranslate() {
        return new CustomExceptionTranslate(){

            public boolean support(@NonNull Throwable e) {
                return e instanceof AuthorizationException;
            }

            public ApiResult<String> translate(@NonNull Throwable e) {
                log.error("\u8ba4\u8bc1\u5f02\u5e38\uff1a", e);
                AuthorizationException exception = (AuthorizationException)((Object)e);
                if (exception.getApiCode() != null) {
                    return ApiResult.fail((ApiCode)exception.getApiCode(), (String)exception.getMessage());
                }
                return ApiResult.fail((ApiCode)ApiCode.BAD_REQUEST, (String)e.getMessage());
            }
        };
    }
}

