/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.security.configurer.filter;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.boot.auth.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class AccessTokenRenewalFilter
extends OncePerRequestFilter {
    private static final Logger log = LogManager.getLogger(AccessTokenRenewalFilter.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthenticationCache authenticationCache;
    private final JwtDecoder jwtDecoder;
    private BearerTokenResolver bearerTokenResolver = new DefaultBearerTokenResolver();
    private Cache<String, String> tokenRefreshCache = null;
    private final List<RequestMatcher> requestMatcherIgnore;

    public AccessTokenRenewalFilter(AuthorizationProperties authorizationProperties, AuthenticationCache authenticationCache, JwtDecoder jwtDecoder) {
        this.authorizationProperties = authorizationProperties;
        this.authenticationCache = authenticationCache;
        this.jwtDecoder = jwtDecoder;
        this.tokenRefreshCache = Caffeine.newBuilder().expireAfterWrite(authorizationProperties.getTokenRenewal()).maximumSize(5000L).build();
        this.requestMatcherIgnore = List.of(new AntPathRequestMatcher("/rpc/**"), new AntPathRequestMatcher("/actuator/**"));
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (this.isRenewal()) {
            if (!this.needRefresh(request)) {
                log.debug("\u65e0\u9700\u5237\u65b0token\u7684uri\uff1a{}", (Object)request.getRequestURI());
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String token = this.bearerTokenResolver.resolve(request);
            if (StringUtils.hasText((String)token)) {
                this.refreshTokenTtl(token);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void refreshTokenTtl(String token) {
        String exists = (String)this.tokenRefreshCache.getIfPresent((Object)token);
        if (exists == null) {
            CompletableFuture.runAsync(() -> {
                Jwt jwt = null;
                try {
                    jwt = this.jwtDecoder.decode(token);
                }
                catch (JwtException e) {
                    log.error("\u7eed\u671ftoken\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    return;
                }
                if (jwt.getExpiresAt() == null) {
                    return;
                }
                if (!"us".equals(jwt.getClaimAsString("yst_pt"))) {
                    return;
                }
                this.authenticationCache.expireAt(token, this.authorizationProperties.getTokenRenewal());
                this.tokenRefreshCache.put((Object)token, (Object)"true");
            });
        }
    }

    private boolean needRefresh(HttpServletRequest request) {
        for (RequestMatcher requestMatcher : this.requestMatcherIgnore) {
            if (!requestMatcher.matches(request)) continue;
            return false;
        }
        return true;
    }

    private boolean isRenewal() {
        return this.authorizationProperties.getTokenRenewal() != null && this.authorizationProperties.getTokenRenewal().getSeconds() > 0L;
    }

    public void setBearerTokenResolver(@NonNull BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }
}

