package com.elitescloud.boot.auth.client.common;

import com.elitescloud.boot.constant.OpenFeignConstant;
import org.springframework.lang.NonNull;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * 系统拦截路径.
 * <p>
 * 白名单和黑名单
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/5
 */
public class InterceptUri {

    /**
     * 白名单
     */
    private static final Set<String> ALLOW_URI = new HashSet<>();
    private static final Set<String> REJECT_URI = new HashSet<>();

    private InterceptUri() {
    }

    static {
        // 内置的白名单
        // 认证相关
        ALLOW_URI.add("/oauth2/**");
        ALLOW_URI.add("/oauth/**");
        ALLOW_URI.add("/oauth/sso/**");
        ALLOW_URI.add("/login.html");

        // swagger相关
        ALLOW_URI.add("/doc.html");
        ALLOW_URI.add("/doc/index.html");
        ALLOW_URI.add("/webjars/**");
        ALLOW_URI.add("/swagger-resources");
        ALLOW_URI.add("/*/api-docs");

        // 静态资源
        ALLOW_URI.add("/**/*.css");
        ALLOW_URI.add("/**/*.js");
        ALLOW_URI.add("/**/*.svg");
        ALLOW_URI.add("/**/*.ttf");
        ALLOW_URI.add("/**/*.woff");
        ALLOW_URI.add("/**/*.woff2");
        ALLOW_URI.add("/**/*.ico");

        // OpenFeign
        ALLOW_URI.add(OpenFeignConstant.URI_PREFIX + "/**");

        // 健康检查
        ALLOW_URI.add("/actuator/**");
    }

    /**
     * 添加白名单
     * 需在系统初始化bean之前设置
     *
     * @param allowUri
     */
    public static void addAllowUri(@NonNull Set<String> allowUri) {
        ALLOW_URI.addAll(allowUri);
    }

    /**
     * 添加黑名单
     * 需在系统初始化bean之前设置
     *
     * @param rejectUri
     */
    public static void addRejectUri(@NonNull Set<String> rejectUri) {
        REJECT_URI.addAll(rejectUri);
    }

    /**
     * 获取白名单
     *
     * @return
     */
    public static Set<String> getAllowUri() {
        return Collections.unmodifiableSet(ALLOW_URI);
    }

    /**
     * 获取黑名单
     *
     * @return
     */
    public static Set<String> getRejectUri() {
        return Collections.unmodifiableSet(REJECT_URI);
    }
}
