package com.elitescloud.boot.auth.client.config;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.boot.web.exception.GlobalExceptionHandler;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/21
 */
@ConditionalOnClass(GlobalExceptionHandler.class)
@Log4j2
class AuthorizationExceptionAutoConfiguration {

    @Bean
    public CustomExceptionTranslate authorizationExceptionTranslate() {
        log.info("CustomExceptionTranslate：{}", AuthenticationException.class.getName());
        return new CustomExceptionTranslate() {
            @Override
            public boolean support(@NonNull Throwable e) {
                return e instanceof AuthenticationException;
            }

            @Override
            public ApiResult<String> translate(@NonNull Throwable e) {
                log.info("认证异常：", e);
                if (e instanceof AuthorizationException) {
                    AuthorizationException exception = (AuthorizationException) e;
                    if (exception.getApiCode() != null) {
                        return ApiResult.fail(exception.getApiCode(), exception.getMessage());
                    }
                }
                if (e instanceof OAuth2AuthenticationException) {
                    return ApiResult.fail(ApiCode.UNAUTHORIZED, e.getMessage());
                }

                return ApiResult.fail(ApiCode.BAD_REQUEST, e.getMessage());
            }
        };
    }
}
