package com.elitescloud.boot.auth.client.config.security.handler;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.ApiCode;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 无权限访问处理.
 * <p>
 * 对于403类错误（认证过，但是没有授权）
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/28
 */
@Log4j2
public class DefaultAccessDeniedHandler extends AbstractHandler implements AccessDeniedHandler {

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        log.error("无权限：", accessDeniedException);

        var result = ApiResult.fail(ApiCode.NOT_PERMISSION);
        writeResponse(response, result, HttpStatus.FORBIDDEN);
    }
}
