/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.tool;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.BaseCallbackWrapper;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public class RedisHelper {
    private final RedisUtils redisUtils;
    private BaseCallbackWrapper callbackWrapper = new DefaultRedisCallbackWrapper();

    public RedisHelper(@Nullable RedisUtils redisUtils, @Nullable BaseCallbackWrapper callbackWrapper) {
        this.redisUtils = redisUtils;
        if (callbackWrapper != null) {
            this.callbackWrapper = callbackWrapper;
        }
    }

    public <T> T execute(Function<RedisUtils, T> callable) {
        if (this.redisUtils == null) {
            throw new IllegalStateException("RedisUtil\u672a\u627e\u5230");
        }
        try {
            return (T)this.callbackWrapper.apply(() -> callable.apply(this.redisUtils), null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Redis\u5f02\u5e38", e);
        }
    }

    private static class DefaultRedisCallbackWrapper
    implements BaseCallbackWrapper {
        private DefaultRedisCallbackWrapper() {
        }

        public Object apply(Supplier callable, Object o) {
            return callable.get();
        }
    }
}

