/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.security.configurer.filter;

import com.elitescloud.boot.auth.cas.model.AuthClientUserDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.boot.auth.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class AccessTokenRenewalFilter
extends OncePerRequestFilter {
    private static final Logger log = LogManager.getLogger(AccessTokenRenewalFilter.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthenticationCache authenticationCache;
    private final JwtDecoder jwtDecoder;
    private final UserTransferHelper userTransferHelper;
    private BearerTokenResolver bearerTokenResolver = new DefaultBearerTokenResolver();
    private Cache<String, String> tokenRefreshCache = null;
    private final List<RequestMatcher> requestMatcherIgnore;
    private final ThreadPoolExecutor threadPoolExecutor;

    public AccessTokenRenewalFilter(AuthorizationProperties authorizationProperties, AuthenticationCache authenticationCache, JwtDecoder jwtDecoder) {
        this.authorizationProperties = authorizationProperties;
        this.authenticationCache = authenticationCache;
        this.jwtDecoder = jwtDecoder;
        this.userTransferHelper = UserTransferHelper.getInstance((String)authorizationProperties.getIssuerUrl());
        this.tokenRefreshCache = Caffeine.newBuilder().expireAfterWrite(authorizationProperties.getTokenRenewalRate()).maximumSize(5000L).build();
        this.requestMatcherIgnore = List.of(new AntPathRequestMatcher("/rpc/**"), new AntPathRequestMatcher("/actuator/**"));
        this.threadPoolExecutor = ThreadPoolHolder.createThreadPool((String)"renewToken-", (Integer)4, (Integer)8);
    }

    public void setBearerTokenResolver(@NonNull BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (!this.needRefresh(request)) {
            log.debug("\u65e0\u9700\u5237\u65b0token\u7684uri\uff1a{}", (Object)request.getRequestURI());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = this.bearerTokenResolver.resolve(request);
        if (StringUtils.hasText((String)token)) {
            this.refreshTokenTtl(token);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void refreshTokenTtl(String token) {
        String exists = (String)this.tokenRefreshCache.getIfPresent((Object)token);
        if (exists == null) {
            CompletableFuture.runAsync(() -> {
                Jwt jwt = null;
                try {
                    jwt = this.jwtDecoder.decode(token);
                }
                catch (JwtException e) {
                    log.error("\u7eed\u671ftoken\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    return;
                }
                if (!"us".equals(jwt.getClaimAsString("yst_pt"))) {
                    return;
                }
                this.tokenRefreshCache.put((Object)token, (Object)"true");
                Duration tokenTtl = null;
                String casUserId = jwt.getClaimAsString("yst_cui");
                String clientId = jwt.getClaimAsString("yst_cli");
                if (StringUtils.hasText((String)clientId) && StringUtils.hasText((String)casUserId)) {
                    Result resValidate = this.userTransferHelper.validateClientUser(clientId, Long.valueOf(Long.parseLong(casUserId)));
                    if (resValidate.getData() == null) {
                        log.warn("\u9a8c\u8bc1\u7528\u6237\u4e0d\u901a\u8fc7\uff1a{}, {}", (Object)casUserId, (Object)resValidate.getMsg());
                        this.authenticationCache.expireAt(token, Duration.ofSeconds(1L));
                        return;
                    }
                    if (Boolean.FALSE.equals(((AuthClientUserDTO)resValidate.getData()).getTokenRenewal())) {
                        log.debug("\u4e0d\u652f\u6301\u81ea\u52a8\u7eed\u671f\uff1a{}", (Object)casUserId);
                        return;
                    }
                    tokenTtl = ((AuthClientUserDTO)resValidate.getData()).getTokenTtl();
                    log.debug("\u6839\u636eCAS\u81ea\u52a8\u7eed\u671f");
                } else {
                    tokenTtl = this.authorizationProperties.getTokenRenewal();
                    log.debug("\u6839\u636e\u5e94\u7528\u914d\u7f6e\u81ea\u52a8\u7eed\u671f");
                }
                if (tokenTtl != null && tokenTtl.toSeconds() > 0L) {
                    log.info("\u81ea\u52a8\u7eed\u671ftoken\uff1a{}, {}min", (Object)token, (Object)tokenTtl.toMinutes());
                    this.authenticationCache.expireAt(token, tokenTtl);
                }
            }, this.threadPoolExecutor);
        }
    }

    private boolean needRefresh(HttpServletRequest request) {
        for (RequestMatcher requestMatcher : this.requestMatcherIgnore) {
            if (!requestMatcher.matches(request)) continue;
            return false;
        }
        return true;
    }

    private Duration localTokenTtl() {
        Duration duration = this.authorizationProperties.getTokenRenewal();
        if (duration != null && duration.toSeconds() > 0L) {
            return duration;
        }
        log.debug("\u4e0d\u652f\u6301\u81ea\u52a8\u7eed\u671f");
        return null;
    }
}

