/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.support.dubbo;

import com.elitescloud.boot.auth.client.config.support.AuthenticationContext;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.condition.ConditionalOnRpc;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Import(value={AuthorizationOnDubboConfig.class, AuthorizationOnNoDubboConfig.class})
@ConditionalOnRpc(requiredDubbo=true)
public class SecurityDubboConfig {

    @ConditionalOnMissingClass(value={"org.apache.dubbo.config.bootstrap.DubboBootstrap"})
    static class AuthorizationOnNoDubboConfig {
        AuthorizationOnNoDubboConfig() {
        }
    }

    static class AuthorizationOnDubboConfig {
        private static final Logger log = LogManager.getLogger(AuthorizationOnDubboConfig.class);

        AuthorizationOnDubboConfig() {
        }

        @Bean
        public AuthenticationContext dubboAuthenticationContext() {
            return new AuthenticationContext(){

                @Override
                public Long getUserId() {
                    String userIdStr = this.getParamFromDubbo("current_user_id");
                    if (StringUtils.hasText((String)userIdStr)) {
                        return Long.parseLong(userIdStr);
                    }
                    return null;
                }

                @Override
                public String getUsername() {
                    String username = this.getParamFromDubbo("current_user_name");
                    if (StringUtils.hasText((String)username)) {
                        return username;
                    }
                    return null;
                }

                @Override
                public Long getTenantId() {
                    String tenantIdStr = this.getParamFromDubbo("X-Tenant-Id");
                    if (StringUtils.hasText((String)tenantIdStr)) {
                        return Long.parseLong(tenantIdStr);
                    }
                    return null;
                }

                @Override
                public GeneralUserDetails getUser() {
                    String token = this.getParamFromDubbo("current_auth_token");
                    if (!StringUtils.hasText((String)token)) {
                        log.info("dubbo\u672a\u4f20\u9012\u7528\u6237token");
                        return null;
                    }
                    return SecurityContextUtil.convertToken(token);
                }

                private String getParamFromDubbo(String key) {
                    return RpcContext.getServiceContext().getAttachment(key);
                }
            };
        }
    }
}

