package com.elitescloud.boot.auth.client.config.security;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

/**
 * OAuth2 Resource端配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/10
 */
@Log4j2
@ConditionalOnProperty(prefix = AuthorizationProperties.CONFIG_PREFIX, name = "type", havingValue = "oauth2_resource")
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class OAuth2ResourceServletSecurityConfig extends AbstractServletSecurityConfig {

    @Bean(SECURITY_CHAIN_DEFAULT)
    @ConditionalOnMissingBean(name = SECURITY_CHAIN_DEFAULT)
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        super.defaultSecurityConfig(http);

        // 资源服务器配置
        http.oauth2ResourceServer(super.oauth2ResourceServer());

        return http.build();
    }
}
