package com.elitescloud.boot.auth.client.tool;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.BaseCallbackWrapper;
import org.springframework.lang.Nullable;

import java.util.function.Function;
import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/20
 */
@SuppressWarnings("unchecked")
public class RedisHelper {

    private final RedisUtils redisUtils;
    private BaseCallbackWrapper callbackWrapper = new DefaultRedisCallbackWrapper();

    public RedisHelper(@Nullable RedisUtils redisUtils, @Nullable BaseCallbackWrapper callbackWrapper) {
        this.redisUtils = redisUtils;

        if (callbackWrapper != null) {
            this.callbackWrapper = callbackWrapper;
        }
    }

    public <T> T execute(Function<RedisUtils, T> callable) {
        if (redisUtils == null) {
            throw new IllegalStateException("RedisUtil未找到");
        }
        try {
            return (T) callbackWrapper.apply(() -> callable.apply(redisUtils), null);
        } catch (Exception e) {
            throw new IllegalStateException("Redis异常", e);
        }
    }

    private static class DefaultRedisCallbackWrapper implements BaseCallbackWrapper {
        @Override
        public Object apply(Supplier callable, Object o) {
            return callable.get();
        }
    }
}
