/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config;

import com.elitescloud.boot.auth.client.client.config.OAuthClientProperties;
import com.elitescloud.boot.auth.client.common.AuthorizationType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class AuthorizationProperties {
    public static final String CONFIG_PREFIX = "elitesland.authorization";
    private Boolean enabled = true;
    private AuthorizationType type = AuthorizationType.SINGLE;
    private Duration tokenTtl = Duration.ofHours(2L);
    private Duration refreshTokenTtl = Duration.ofHours(6L);
    private Duration tokenRenewal = Duration.ofHours(2L);
    private Duration tokenRenewalRate = Duration.ofMinutes(10L);
    private Boolean anonymousEnabled = false;
    private Set<String> allowList = new HashSet<String>(8);
    private Set<String> rejectList = new HashSet<String>(8);
    private RequestMatcherType requestMatcherType = RequestMatcherType.ANT;
    private Boolean csrfEnabled = false;
    private Boolean corsEnabled = false;
    private List<CorsConfig> cors = new ArrayList<CorsConfig>();
    private Boolean sessionEnabled;
    @NestedConfigurationProperty
    private OAuthClientProperties client = new OAuthClientProperties();
    private String rolePrefix = "ROLE_";
    private String loginPage = null;
    private String issuerUrl = null;
    private String redirectUriPrefix = null;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AuthorizationType getType() {
        return this.type;
    }

    public void setType(AuthorizationType type) {
        this.type = type;
    }

    public Duration getTokenTtl() {
        return this.tokenTtl;
    }

    public void setTokenTtl(Duration tokenTtl) {
        this.tokenTtl = tokenTtl;
    }

    public void setRefreshTokenTtl(Duration refreshTokenTtl) {
        this.refreshTokenTtl = refreshTokenTtl;
    }

    public Duration getTokenRenewal() {
        return this.tokenRenewal;
    }

    public void setTokenRenewal(Duration tokenRenewal) {
        this.tokenRenewal = tokenRenewal;
    }

    public Duration getTokenRenewalRate() {
        return this.tokenRenewalRate;
    }

    public void setTokenRenewalRate(Duration tokenRenewalRate) {
        this.tokenRenewalRate = tokenRenewalRate;
    }

    public Boolean getAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public void setAnonymousEnabled(Boolean anonymousEnabled) {
        this.anonymousEnabled = anonymousEnabled;
    }

    public Set<String> getAllowList() {
        return this.allowList;
    }

    public void setAllowList(Set<String> allowList) {
        this.allowList = allowList;
    }

    public Set<String> getRejectList() {
        return this.rejectList;
    }

    public void setRejectList(Set<String> rejectList) {
        this.rejectList = rejectList;
    }

    public Duration getRefreshTokenTtl() {
        return this.refreshTokenTtl;
    }

    public RequestMatcherType getRequestMatcherType() {
        return this.requestMatcherType;
    }

    public void setRequestMatcherType(RequestMatcherType requestMatcherType) {
        this.requestMatcherType = requestMatcherType;
    }

    public Boolean getCsrfEnabled() {
        return this.csrfEnabled;
    }

    public void setCsrfEnabled(Boolean csrfEnabled) {
        this.csrfEnabled = csrfEnabled;
    }

    public Boolean getCorsEnabled() {
        return this.corsEnabled;
    }

    public void setCorsEnabled(Boolean corsEnabled) {
        this.corsEnabled = corsEnabled;
    }

    public List<CorsConfig> getCors() {
        return this.cors;
    }

    public void setCors(List<CorsConfig> cors) {
        this.cors = cors;
    }

    public Boolean getSessionEnabled() {
        if (this.sessionEnabled != null) {
            return this.sessionEnabled;
        }
        return AuthorizationType.OAUTH2_SERVER == this.getType();
    }

    public void setSessionEnabled(Boolean sessionEnabled) {
        this.sessionEnabled = sessionEnabled;
    }

    public OAuthClientProperties getClient() {
        return this.client;
    }

    public void setClient(OAuthClientProperties client) {
        this.client = client;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public String getRedirectUriPrefix() {
        return this.redirectUriPrefix;
    }

    public void setRedirectUriPrefix(String redirectUriPrefix) {
        this.redirectUriPrefix = redirectUriPrefix;
    }

    public static enum RequestMatcherType {
        ANT,
        MVC;

    }

    public static class CorsConfig {
        private String pathMatcher = "/**";
        private Set<String> allowedOriginPatterns = new HashSet<String>();
        private Set<String> allowedOrigins = new HashSet<String>();
        private Set<String> allowedHeaders = new HashSet<String>();
        private Set<String> exposeHeaders = new HashSet<String>();
        private Set<String> allowedMethods = new HashSet<String>();
        private boolean allowCredentials;

        public String getPathMatcher() {
            return this.pathMatcher;
        }

        public void setPathMatcher(String pathMatcher) {
            this.pathMatcher = pathMatcher;
        }

        public Set<String> getAllowedOriginPatterns() {
            return this.allowedOriginPatterns;
        }

        public void setAllowedOriginPatterns(Set<String> allowedOriginPatterns) {
            this.allowedOriginPatterns = allowedOriginPatterns;
        }

        public Set<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public void setAllowedOrigins(Set<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public Set<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        public void setAllowedHeaders(Set<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        public Set<String> getExposeHeaders() {
            return this.exposeHeaders;
        }

        public void setExposeHeaders(Set<String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
        }

        public Set<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        public void setAllowedMethods(Set<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public boolean isAllowCredentials() {
            return this.allowCredentials;
        }

        public void setAllowCredentials(boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }
    }
}

