/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.security.configurer.filter;

import com.elitescloud.boot.auth.client.common.SecurityConstants;
import com.elitescloud.boot.auth.client.config.security.handler.DefaultAuthenticationEntryPointHandler;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class AbstractAuthorizationFilter<T extends AbstractAuthenticationToken>
extends OncePerRequestFilter {
    private static final Logger log = LogManager.getLogger(AbstractAuthorizationFilter.class);
    private AuthenticationManager authenticationManager;
    private AuthenticationEntryPoint authenticationEntryPoint = new DefaultAuthenticationEntryPointHandler(null);
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private SecurityContextRepository securityContextRepository = new NullSecurityContextRepository();
    private AuthenticationFailureHandler authenticationFailureHandler = (request, response, exception) -> {
        if (exception instanceof AuthenticationServiceException) {
            throw exception;
        }
        this.authenticationEntryPoint.commence(request, response, exception);
    };

    public AbstractAuthorizationFilter(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    protected abstract T obtain(HttpServletRequest var1) throws AuthenticationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authenticationToken = null;
        try {
            authenticationToken = (Authentication)this.obtain(request);
        }
        catch (AuthenticationException e) {
            log.error("\u89e3\u6790AuthenticationToken\u5f02\u5e38\uff1a", (Throwable)e);
            this.authenticationEntryPoint.commence(request, response, e);
            return;
        }
        if (authenticationToken == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((HttpServletRequest)request).getRequestURI();
            log.trace("{}\u672a\u89e3\u6790\u51fa\u6709\u6548AuthenticationToken", supplierArray);
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication((Authentication)SecurityConstants.AUTHENTICATION_ANONYMOUS);
            SecurityContextHolder.setContext((SecurityContext)context);
            this.securityContextRepository.saveContext(context, request, response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        authenticationToken.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        try {
            Authentication authenticationResult = this.authenticationManager.authenticate(authenticationToken);
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(authenticationResult);
            SecurityContextHolder.setContext((SecurityContext)context);
            this.securityContextRepository.saveContext(context, request, response);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> authenticationResult.getName();
            log.debug("\u8bbe\u7f6e\u5f53\u524d\u8ba4\u8bc1\u7528\u6237\uff1a{}", supplierArray);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (AuthenticationException failed) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25\uff1a{}", authenticationToken);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, failed);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public void afterPropertiesSet() throws ServletException {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager\u4e0d\u80fd\u4e3a\u7a7a");
        super.afterPropertiesSet();
    }

    public void setAuthenticationManager(@NonNull AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationEntryPoint(@NonNull AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationDetailsSource(@NonNull AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationFailureHandler = authenticationFailureHandler;
    }
}

