package com.elitescloud.boot.auth.client.common;

import com.elitescloud.cloudt.common.base.ApiCode;
import org.apache.skywalking.apm.toolkit.trace.IgnoredException;
import org.springframework.security.core.AuthenticationException;

/**
 * 自定义认证异常.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/09
 */
@IgnoredException
public class AuthorizationException extends AuthenticationException {
    private static final long serialVersionUID = -8349296705929335536L;

    private final ApiCode apiCode;

    public AuthorizationException(String msg, Throwable cause) {
        super(msg, cause);
        this.apiCode = null;
    }

    public AuthorizationException(String msg) {
        super(msg);
        this.apiCode = null;
    }

    public AuthorizationException(ApiCode apiCode, String msg) {
        super(msg);
        this.apiCode = apiCode;
    }

    public AuthorizationException(ApiCode apiCode, String msg, Throwable cause) {
        super(msg, cause);
        this.apiCode = apiCode;
    }

    public ApiCode getApiCode() {
        return apiCode == null ? ApiCode.AUTHENTICATION_EXCEPTION : apiCode;
    }
}
